/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.network;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class PacketHandler {
    public static final PacketDistributor<Pair<Level, BlockPos>> TRACKING_CHUNK_AND_NEAR = new PacketDistributor((_d, pairSupplier) -> {
        Pair pair = (Pair)pairSupplier.get();
        Level level = (Level)pair.getFirst();
        BlockPos blockpos = (BlockPos)pair.getSecond();
        ChunkPos chunkpos = new ChunkPos(blockpos);
        return packet -> {
            List players = ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(chunkpos, false);
            for (ServerPlayer player : players) {
                if (!(player.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()) < 4096.0)) continue;
                player.f_8906_.m_9829_(packet);
            }
        };
    }, NetworkDirection.PLAY_TO_CLIENT);

    public static ServerPlayer getPlayer(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalArgumentException("Wrong side for server packet handler " + context.getDirection());
        }
        context.setPacketHandled(true);
        return Objects.requireNonNull(context.getSender());
    }

    public static void sendTo(SimpleChannel channel, ServerPlayer playerMP, Object toSend) {
        channel.sendTo(toSend, playerMP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendNonLocal(SimpleChannel channel, ServerPlayer playerMP, Object toSend) {
        if (playerMP.f_8924_.m_6982_() || !playerMP.m_36316_().getName().equals(playerMP.f_8924_.m_130009_())) {
            PacketHandler.sendTo(channel, playerMP, toSend);
        }
    }

    public static void sendToTracking(SimpleChannel channel, Level level, BlockPos pos, Object msg) {
        channel.send(TRACKING_CHUNK_AND_NEAR.with(() -> Pair.of((Object)level, (Object)pos)), msg);
    }

    public static void sendTo(SimpleChannel channel, Player entity, Object msg) {
        channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), msg);
    }

    public static void sendToServer(SimpleChannel channel, Object msg) {
        channel.sendToServer(msg);
    }
}

