/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.network.playerskin;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.blatfan.blatapi.fluffy_fur.FluffyFur;
import ru.blatfan.blatapi.fluffy_fur.common.capability.IPlayerSkin;
import ru.blatfan.blatapi.fluffy_fur.common.network.ClientPacket;

public class PlayerSkinUpdatePacket
extends ClientPacket {
    private final UUID uuid;
    private CompoundTag tag;

    public PlayerSkinUpdatePacket(UUID uuid, CompoundTag tag) {
        this.uuid = uuid;
        this.tag = tag;
    }

    public PlayerSkinUpdatePacket(Player entity) {
        this.uuid = entity.m_20148_();
        entity.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(k -> {
            this.tag = (CompoundTag)((INBTSerializable)k).serializeNBT();
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        Level level = FluffyFur.proxy.getLevel();
        Player player = level.m_46003_(this.uuid);
        if (player != null) {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(k -> ((INBTSerializable)k).deserializeNBT((Tag)this.tag));
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, PlayerSkinUpdatePacket.class, PlayerSkinUpdatePacket::encode, PlayerSkinUpdatePacket::decode, ClientPacket::handle);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130079_(this.tag);
    }

    public static PlayerSkinUpdatePacket decode(FriendlyByteBuf buf) {
        return new PlayerSkinUpdatePacket(buf.m_130259_(), buf.m_130260_());
    }
}

