/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FluffyFurClientConfig {
    public static ForgeConfigSpec.ConfigValue<Boolean> ITEM_PARTICLE;
    public static ForgeConfigSpec.ConfigValue<Boolean> ITEM_GUI_PARTICLE;
    public static ForgeConfigSpec.ConfigValue<Boolean> ITEM_IN_HAND_PARTICLE;
    public static ForgeConfigSpec.ConfigValue<Boolean> BLOOD_PARTICLE;
    public static ForgeConfigSpec.ConfigValue<Boolean> LIGHTNING_BOLT_EFFECT;
    public static ForgeConfigSpec.ConfigValue<Boolean> EXPLOSION_EFFECT;
    public static ForgeConfigSpec.ConfigValue<Boolean> MENU_BUTTON;
    public static ForgeConfigSpec.ConfigValue<Integer> MENU_BUTTON_ROW;
    public static ForgeConfigSpec.ConfigValue<Integer> MENU_BUTTON_ROW_X_OFFSET;
    public static ForgeConfigSpec.ConfigValue<Integer> MENU_BUTTON_X_OFFSET;
    public static ForgeConfigSpec.ConfigValue<Integer> MENU_BUTTON_Y_OFFSET;
    public static ForgeConfigSpec.ConfigValue<Double> SCREENSHAKE_INTENSITY;
    public static ForgeConfigSpec.ConfigValue<String> PANORAMA;
    public static ForgeConfigSpec.ConfigValue<String> CUSTOM_WINDOW_TITLE;
    public static final FluffyFurClientConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public FluffyFurClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Graphics").push("graphics");
        SCREENSHAKE_INTENSITY = builder.comment("Intensity of screenshake.").defineInRange("screenshakeIntensity", 1.0, 0.0, 10.0);
        builder.comment("Particles").push("particles");
        ITEM_PARTICLE = builder.comment("Enable dropping items particles.").define("itemParticle", true);
        ITEM_GUI_PARTICLE = builder.comment("Enable items particles in GUI.").define("itemGuiParticle", true);
        ITEM_IN_HAND_PARTICLE = builder.comment("Enable items GUI particles in hand.").define("itemParticleInHand", true);
        BLOOD_PARTICLE = builder.comment("Enable blood particles in case of damage.").define("bloodParticle", true);
        LIGHTNING_BOLT_EFFECT = builder.comment("Enable custom effect of lightning bolt.").define("lightningBoltEffect", true);
        EXPLOSION_EFFECT = builder.comment("Enable custom effect of explosion.").define("explosionEffect", true);
        builder.pop();
        builder.pop();
        builder.comment("Menu").push("menu");
        PANORAMA = builder.comment("Fluffy Fur Panorama.").define("panorama", (Object)"minecraft:vanilla");
        MENU_BUTTON = builder.comment("Enable Fluffy Fur menu button.").define("menuButton", true);
        MENU_BUTTON_ROW = builder.comment("Fluffy Fur menu button row.").defineInRange("menuButtonRow", 1, 0, 4);
        MENU_BUTTON_ROW_X_OFFSET = builder.comment("Fluffy Fur menu button X offset with row.").define("menuButtonRowXOffset", (Object)4);
        MENU_BUTTON_X_OFFSET = builder.comment("Fluffy Fur menu button X offset.").define("menuButtonXOffset", (Object)0);
        MENU_BUTTON_Y_OFFSET = builder.comment("Fluffy Fur menu button Y offset.").define("menuButtonYOffset", (Object)0);
        CUSTOM_WINDOW_TITLE = builder.define("custom_window_title", (Object)"empty_title");
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(FluffyFurClientConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (FluffyFurClientConfig)specPair.getLeft();
    }
}

