/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.mixins.common;

import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.blatfan.blatapi.common.BARegistry;
import ru.blatfan.blatapi.common.recipe.IAnvilRecipe;
import ru.blatfan.blatapi.utils.DisabledRecipes;
import ru.blatfan.blatapi.utils.ItemHelper;

@Mixin(value={AnvilMenu.class})
public abstract class MixinAnvilMenu
extends ItemCombinerMenu {
    @Final
    @Shadow
    private DataSlot f_39002_;
    @Shadow
    private String f_39001_;
    @Shadow
    public int f_39000_;

    public MixinAnvilMenu(@Nullable MenuType<?> type, int containerId, Inventory container, ContainerLevelAccess access) {
        super(type, containerId, container, access);
    }

    @Shadow
    public abstract void m_6640_();

    @Inject(at={@At(value="HEAD")}, method={"mayPickup"}, cancellable=true)
    protected void mayPickup(Player player, boolean b, CallbackInfoReturnable<Boolean> callback) {
        callback.setReturnValue((Object)(player.m_150110_().f_35937_ || player.f_36078_ >= this.f_39002_.m_6501_() ? 1 : 0));
        callback.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"onTake"}, cancellable=true)
    protected void onTake(Player player, ItemStack stack, CallbackInfo callback) {
        callback.cancel();
        if (!player.m_150110_().f_35937_) {
            player.m_6749_(-this.f_39002_.m_6501_());
        }
        this.f_39002_.m_6422_(0);
        float breakChance = ForgeHooks.onAnvilRepair((Player)player, (ItemStack)stack, (ItemStack)this.f_39769_.m_8020_(0), (ItemStack)this.f_39769_.m_8020_(1));
        IAnvilRecipe recipe = this.f_39771_.m_9236_().m_7465_().m_44015_((RecipeType)BARegistry.ANVIL.get(), this.f_39769_, this.f_39771_.m_9236_()).orElse(null);
        if (recipe != null) {
            ItemStack returnItem;
            ItemStack input1 = this.f_39769_.m_8020_(0);
            ItemStack input2 = this.f_39769_.m_8020_(1);
            int input1Slot = 0;
            int input2Slot = 1;
            if (!recipe.getInput(0).test(this.f_39769_.m_8020_(0)) || !recipe.getInput(1).test(this.f_39769_.m_8020_(1))) {
                input1 = this.f_39769_.m_8020_(1);
                input2 = this.f_39769_.m_8020_(0);
                input1Slot = 1;
                input2Slot = 0;
            }
            if (recipe.isConsuming(0)) {
                if (recipe.isUsingDurability(0) && input1.m_41763_()) {
                    input1.m_41622_(recipe.getInputCount(0), (LivingEntity)this.f_39771_, p -> this.f_39770_.m_39292_((level, pos) -> level.m_46796_(1029, pos, 0)));
                } else {
                    input1.m_41774_(recipe.getInputCount(0));
                }
            }
            if (!recipe.getReturn(0).m_41619_()) {
                returnItem = recipe.getReturn(0).m_41777_();
                if (input1.m_41619_()) {
                    this.f_39769_.m_6836_(input1Slot, returnItem);
                } else if (!recipe.isUsingDurability(0)) {
                    if (ItemHelper.canCombineStacks(input1, returnItem)) {
                        this.f_39769_.m_6836_(input1Slot, ItemHelper.combineStacks(input1, returnItem));
                    } else {
                        this.f_39770_.m_39292_((level, pos) -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)returnItem));
                    }
                }
            }
            if (recipe.isConsuming(1)) {
                if (recipe.isUsingDurability(1) && input2.m_41763_()) {
                    input2.m_41622_(recipe.getInputCount(1), (LivingEntity)this.f_39771_, p -> this.f_39770_.m_39292_((level, pos) -> level.m_46796_(1029, pos, 0)));
                } else {
                    input2.m_41774_(recipe.getInputCount(1));
                }
            }
            if (!recipe.getReturn(1).m_41619_()) {
                returnItem = recipe.getReturn(1).m_41777_();
                if (input2.m_41619_()) {
                    this.f_39769_.m_6836_(input2Slot, returnItem);
                } else if (!recipe.isUsingDurability(1)) {
                    if (ItemHelper.canCombineStacks(input2, returnItem)) {
                        this.f_39769_.m_6836_(input2Slot, ItemHelper.combineStacks(input2, returnItem));
                    } else {
                        this.f_39770_.m_39292_((level, pos) -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)returnItem));
                    }
                }
            }
            this.m_6640_();
        } else {
            this.f_39769_.m_6836_(0, ItemStack.f_41583_);
            if (this.f_39000_ > 0) {
                ItemStack itemstack = this.f_39769_.m_8020_(1);
                if (!itemstack.m_41619_() && itemstack.m_41613_() > this.f_39000_) {
                    itemstack.m_41774_(this.f_39000_);
                    this.f_39769_.m_6836_(1, itemstack);
                } else {
                    this.f_39769_.m_6836_(1, ItemStack.f_41583_);
                }
            } else {
                this.f_39769_.m_6836_(1, ItemStack.f_41583_);
            }
        }
        this.f_39770_.m_39292_((level, pos) -> {
            BlockState blockstate = level.m_8055_(pos);
            if (!player.m_150110_().f_35937_ && blockstate.m_204336_(BlockTags.f_13033_) && player.m_217043_().m_188501_() < breakChance) {
                BlockState state1 = AnvilBlock.m_48824_((BlockState)blockstate);
                if (state1 == null) {
                    level.m_7471_(pos, false);
                    level.m_46796_(1029, pos, 0);
                } else {
                    level.m_7731_(pos, state1, 2);
                    level.m_46796_(1030, pos, 0);
                }
            } else {
                level.m_46796_(1030, pos, 0);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"createResult"}, cancellable=true)
    public void createResult(CallbackInfo callback) {
        Level level = this.f_39771_.m_9236_();
        IAnvilRecipe recipe = level.m_7465_().m_44015_((RecipeType)BARegistry.ANVIL.get(), this.f_39769_, level).orElse(null);
        if (recipe != null) {
            ItemStack stack = recipe.m_8043_(level.m_9598_());
            ItemStack output = recipe.m_5874_(this.f_39769_, level.m_9598_());
            int exp = recipe.getExperience();
            if (StringUtils.isBlank((CharSequence)this.f_39001_)) {
                if (stack.m_41788_()) {
                    ++exp;
                    output.m_41787_();
                }
            } else if (!this.f_39001_.equals(stack.m_41786_().getString())) {
                ++exp;
                output.m_41714_((Component)Component.m_237113_((String)this.f_39001_));
            }
            this.f_39002_.m_6422_(exp);
            this.f_39768_.m_6836_(0, output);
            this.m_38946_();
            callback.cancel();
        } else {
            ItemStack baseItem = this.f_39769_.m_8020_(0);
            ItemStack secondItem = this.f_39769_.m_8020_(1);
            if (secondItem.m_41720_() == Items.f_42690_ && EnchantmentHelper.m_44831_((ItemStack)secondItem).entrySet().stream().anyMatch(entry -> DisabledRecipes.isEnchantmentDisabled(baseItem, (Enchantment)entry.getKey(), (Integer)entry.getValue()))) {
                callback.cancel();
                this.f_39768_.m_6836_(0, ItemStack.f_41583_);
                this.m_38946_();
            }
            if (baseItem.m_41720_() == Items.f_42690_ && EnchantmentHelper.m_44831_((ItemStack)baseItem).entrySet().stream().anyMatch(entry -> DisabledRecipes.isEnchantmentDisabled(null, (Enchantment)entry.getKey(), (Integer)entry.getValue()))) {
                callback.cancel();
                this.f_39768_.m_6836_(0, ItemStack.f_41583_);
                this.m_38946_();
            }
        }
    }
}

