/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.mixins.common;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraftforge.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.blatfan.blatapi.common.biome_replacer.BABiomeSource;
import ru.blatfan.blatapi.common.biome_replacer.BiomeRaplacerModule;
import ru.blatfan.blatapi.common.biome_replacer.TerrablenderHelper;
import ru.blatfan.blatapi.utils.BiomeHelper;

@Mixin(value={MultiNoiseBiomeSource.class}, priority=-800)
public abstract class MultiNoiseBiomeSourceMixin {
    @Shadow
    @Final
    private Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> f_48435_;

    @Shadow
    public abstract Climate.ParameterList<Holder<Biome>> m_274409_();

    @Inject(method={"getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void elysium$getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, CallbackInfoReturnable<Holder<Biome>> cir) {
        BABiomeSource source;
        Holder currentBiome = FMLLoader.getLoadingModList().getModFileById("terrablender") != null ? TerrablenderHelper.getCurrentBiome((MultiNoiseBiomeSource)this, x, y, z, sampler) : (Holder)this.m_274409_().m_204252_(sampler.m_183445_(x, y, z));
        MultiNoiseBiomeSourceMixin multiNoiseBiomeSourceMixin = this;
        if (multiNoiseBiomeSourceMixin instanceof BABiomeSource && (source = (BABiomeSource)((Object)multiNoiseBiomeSourceMixin)).getDimension() != null) {
            boolean biomeReplacedInThisIteration;
            List<BiomeHelper.BiomeReplacer> biomeReplacers = BiomeHelper.biomesForDimension(source.getDimension());
            boolean biomeReplaced = false;
            block0: do {
                biomeReplacedInThisIteration = false;
                for (BiomeHelper.BiomeReplacer replacer : biomeReplacers) {
                    int scaledZ;
                    int scaledX;
                    long uniqueSeed;
                    double random;
                    if (!currentBiome.m_203565_(replacer.canReplace()) || !((random = new Random(uniqueSeed = this.makeCoordinatesIntoSeed(scaledX = x / replacer.size(), scaledZ = z / replacer.size()) ^ (long)replacer.id().hashCode()).nextDouble()) < replacer.rarity())) continue;
                    currentBiome = BiomeRaplacerModule.registryAccess.m_175515_(Registries.f_256952_).m_246971_(replacer.biome());
                    biomeReplacedInThisIteration = true;
                    biomeReplaced = true;
                    continue block0;
                }
            } while (biomeReplacedInThisIteration);
            if (biomeReplaced) {
                cir.setReturnValue((Object)currentBiome);
            }
        }
    }

    @Unique
    private long makeCoordinatesIntoSeed(int scaledX, int scaledZ) {
        long x = 31L * (long)scaledX + 17L;
        long z = 37L * (long)scaledZ + 23L;
        return (x ^ z) * 25214903917L;
    }
}

