/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;

public final class AttributesUtil {
    static final Random RAND = new Random();
    public static final UUID DEFAULT_ID = UUID.fromString("06d30aa2-eff2-4a81-b92b-a1cb95f115c6");
    public static final UUID MULT_ID = UUID.fromString("c6d30aa2-eff2-4a81-b92b-a1cb95f115cd");
    public static final UUID ID_STEP_HEIGHT = UUID.fromString("66d30aa2-eaa2-4a81-b92b-a1cb95f115ca");
    static final float VANILLA = 0.6f;

    public static void disableStepHeight(Player player) {
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        attr.m_22120_(ID_STEP_HEIGHT);
    }

    public static void enableStepHeight(Player player) {
        double old;
        float newVal = player.m_6047_() ? 0.29999995f : 0.46249998f;
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        AttributeModifier oldModifier = attr.m_22111_(ID_STEP_HEIGHT);
        double d = old = oldModifier == null ? 0.0 : oldModifier.m_22218_();
        if ((double)newVal != old) {
            AttributesUtil.setStepHeightInternal(player, newVal);
        }
    }

    private static void setStepHeightInternal(Player player, double newVal) {
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        attr.m_22120_(ID_STEP_HEIGHT);
        if (newVal != 0.0) {
            AttributeModifier healthModifier = new AttributeModifier(ID_STEP_HEIGHT, "blatapi", newVal, AttributeModifier.Operation.ADDITION);
            attr.m_22125_(healthModifier);
        }
    }

    public static int add(Attribute attribute, Collection<ServerPlayer> players, int integer) {
        for (ServerPlayer playerIn : players) {
            AttributesUtil.updateAttrModifierBy(attribute, DEFAULT_ID, (Player)playerIn, integer);
        }
        return 0;
    }

    public static int addRandom(Attribute attribute, Collection<ServerPlayer> players, int min, int max) {
        for (ServerPlayer playerIn : players) {
            AttributesUtil.updateAttrModifierBy(attribute, DEFAULT_ID, (Player)playerIn, RAND.nextInt(min, max));
        }
        return 0;
    }

    public static int multiply(Attribute attribute, Collection<ServerPlayer> players, double integer) {
        for (ServerPlayer playerIn : players) {
            AttributesUtil.multiplyAttrModifierBy(attribute, (Player)playerIn, integer);
        }
        return 0;
    }

    public static int reset(Attribute attribute, Collection<ServerPlayer> players) {
        for (ServerPlayer playerIn : players) {
            AttributeInstance attr = playerIn.m_21051_(attribute);
            attr.m_22120_(DEFAULT_ID);
            attr.m_22120_(MULT_ID);
        }
        return 0;
    }

    public static void removePlayerReach(UUID id, Player player) {
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        attr.m_22120_(id);
    }

    public static void setPlayerReach(UUID id, Player player, int reachBoost) {
        AttributesUtil.removePlayerReach(id, player);
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        AttributeModifier enchantment = new AttributeModifier(id, "ReachFLIB", (double)reachBoost, AttributeModifier.Operation.ADDITION);
        attr.m_22125_(enchantment);
    }

    public static void updateAttrModifierBy(Attribute attr, UUID id, Player playerIn, int value) {
        AttributeInstance healthAttribute = playerIn.m_21051_(attr);
        AttributeModifier oldHealthModifier = healthAttribute.m_22111_(id);
        double old = oldHealthModifier == null ? 0.0 : oldHealthModifier.m_22218_();
        double newVal = (double)value + old;
        healthAttribute.m_22120_(id);
        AttributeModifier healthModifier = new AttributeModifier(id, "Bonus", newVal, AttributeModifier.Operation.ADDITION);
        healthAttribute.m_22125_(healthModifier);
        if (attr == Attributes.f_22276_ && (double)playerIn.m_21223_() > healthAttribute.m_22135_()) {
            playerIn.m_21153_((float)healthAttribute.m_22135_());
        }
    }

    public static void multiplyAttrModifierBy(Attribute attr, Player playerIn, double value) {
        AttributeInstance healthAttribute = playerIn.m_21051_(attr);
        healthAttribute.m_22120_(MULT_ID);
        AttributeModifier healthModifier = new AttributeModifier(MULT_ID, "Bonus from Cyclic", value, AttributeModifier.Operation.MULTIPLY_BASE);
        healthAttribute.m_22125_(healthModifier);
        if (attr == Attributes.f_22276_ && (double)playerIn.m_21223_() > healthAttribute.m_22135_()) {
            playerIn.m_21153_((float)healthAttribute.m_22135_());
        }
    }

    public static int setHearts(Collection<ServerPlayer> players, int finalHearts) {
        for (ServerPlayer playerIn : players) {
            AttributesUtil.setHearts(finalHearts, playerIn);
        }
        return 0;
    }

    private static void setHearts(int finalHearts, ServerPlayer playerIn) {
        int modifiedHearts = finalHearts - 10;
        AttributeInstance healthAttribute = playerIn.m_21051_(Attributes.f_22276_);
        healthAttribute.m_22120_(DEFAULT_ID);
        AttributeModifier healthModifier = new AttributeModifier(DEFAULT_ID, "HP Bonus", (double)(modifiedHearts * 2), AttributeModifier.Operation.ADDITION);
        healthAttribute.m_22125_(healthModifier);
        if ((double)playerIn.m_21223_() > healthAttribute.m_22135_()) {
            playerIn.m_21153_((float)healthAttribute.m_22135_());
        }
    }

    private AttributesUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

