/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import java.awt.Color;
import java.util.ArrayList;
import org.joml.Vector3f;

public final class ColorHelper {
    public static Color getColor(int decimal) {
        return new Color(decimal);
    }

    public static void RGBToHSV(Color color, float[] hsv) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsv);
    }

    public static Color getColor(String color) {
        if (!color.startsWith("#")) {
            return Color.decode("#" + color);
        }
        return Color.decode(color);
    }

    public static int getColor(Color color) {
        return color.getRGB();
    }

    public static int getColor(int r, int g, int b) {
        return ColorHelper.getColor(new Color(r, g, b));
    }

    public static int getColor(int r, int g, int b, int a) {
        return ColorHelper.getColor(new Color(r, g, b, a));
    }

    public static int getColor(float r, float g, float b, float a) {
        return ColorHelper.getColor(new Color(r, g, b, a));
    }

    public static Color rainbowColor(float ticks) {
        int r = (int)(Math.sin(ticks) * 127.0 + 128.0);
        int g = (int)(Math.sin((double)ticks + 1.5707963267948966) * 127.0 + 128.0);
        int b = (int)(Math.sin((double)ticks + Math.PI) * 127.0 + 128.0);
        return new Color(r, g, b);
    }

    public static Color getBlendColor(ArrayList<Color> colors) {
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (Color color : colors) {
            int k = ColorHelper.getColor(color);
            f += (float)(k >> 16 & 0xFF) / 255.0f;
            f1 += (float)(k >> 8 & 0xFF) / 255.0f;
            f2 += (float)(k >> 0 & 0xFF) / 255.0f;
            ++j;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return ColorHelper.getColor((int)f << 16 | (int)f1 << 8 | (int)f2);
    }

    public static Vector3f getColorV3f(Color color) {
        return new Vector3f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
    }

    public static Color darker(Color color, int times) {
        return ColorHelper.darker(color, times, 0.7f);
    }

    public static Color darker(Color color, int power, float factor) {
        float FACTOR = (float)Math.pow(factor, power);
        return new Color(Math.max((int)((float)color.getRed() * FACTOR), 0), Math.max((int)((float)color.getGreen() * FACTOR), 0), Math.max((int)((float)color.getBlue() * FACTOR), 0), color.getAlpha());
    }

    public static Color brighter(Color color, int power) {
        return ColorHelper.brighter(color, power, 0.7f);
    }

    public static Color brighter(Color color, int power, float factor) {
        float FACTOR = (float)Math.pow(factor, power);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255), alpha);
    }

    private ColorHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

