/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;
import ru.blatfan.blatapi.BlatApi;

public final class DisabledRecipes
implements ResourceManagerReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path PATH = FMLPaths.CONFIGDIR.get().toAbsolutePath();
    private static final List<Pair<Ingredient, Ingredient>> REPAIR = Lists.newArrayList();
    private static final List<Pair<Pair<Enchantment, Integer>, Ingredient>> ENCHANTMENTS = Lists.newArrayList();
    private static final List<Ingredient> REPAIR_ITEMS = Lists.newArrayList();
    private static final List<Pair<Ingredient, Ingredient>> REPAIR_INTERNAL = Lists.newArrayList();
    private static final List<Pair<Pair<Enchantment, Integer>, Ingredient>> ENCHANTMENTS_INTERNAL = Lists.newArrayList();
    private static final List<Ingredient> REPAIR_ITEMS_INTERNAL = Lists.newArrayList();

    public DisabledRecipes() {
        try {
            Files.createDirectory(Paths.get(PATH.toString(), "blatfan/blatapi"), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            BlatApi.LOGGER.debug("{} config directory already exists.", (Object)"blatfan/blatapi");
        }
        catch (IOException e) {
            BlatApi.LOGGER.error("Failed to create {} config directory.", (Object)"blatfan/blatapi");
        }
    }

    public static void disableRepairRecipe(Ingredient baseItem, Ingredient repairItem) {
        REPAIR_INTERNAL.add((Pair<Ingredient, Ingredient>)Pair.of((Object)baseItem, (Object)repairItem));
    }

    public static void disableEnchantmentRecipe(Ingredient baseItem, Enchantment enchantment) {
        DisabledRecipes.disableEnchantmentRecipe(baseItem, enchantment, -1);
    }

    public static void disableEnchantmentRecipe(Ingredient baseItem, Enchantment enchantment, int enchantmentLevel) {
        ENCHANTMENTS_INTERNAL.add((Pair<Pair<Enchantment, Integer>, Ingredient>)Pair.of((Object)Pair.of((Object)enchantment, (Object)enchantmentLevel), (Object)baseItem));
    }

    public static void disableRepairItem(Ingredient repairItem) {
        REPAIR_ITEMS_INTERNAL.add(repairItem);
    }

    public static boolean isRepairDisabled(ItemStack baseItem, @Nullable ItemStack repairItem) {
        return REPAIR.stream().anyMatch(entry -> ((Ingredient)entry.getFirst()).test(baseItem) && (((Ingredient)entry.getSecond()).m_43947_() || ((Ingredient)entry.getSecond()).test(repairItem)));
    }

    public static boolean isEnchantmentDisabled(@Nullable ItemStack baseItem, Enchantment enchantment, int enchantmentLevel) {
        return ENCHANTMENTS.stream().anyMatch(entry -> !(((Pair)entry.getFirst()).getFirst() != enchantment || (Integer)((Pair)entry.getFirst()).getSecond() != -1 && (Integer)((Pair)entry.getFirst()).getSecond() != enchantmentLevel || !((Ingredient)entry.getSecond()).m_43947_() && !((Ingredient)entry.getSecond()).test(baseItem)));
    }

    public static boolean isRepairItemDisabled(ItemStack repairItem) {
        return REPAIR_ITEMS.stream().anyMatch(item -> item.test(repairItem));
    }

    public void m_6213_(ResourceManager manager) {
        REPAIR.clear();
        ENCHANTMENTS.clear();
        REPAIR_ITEMS.clear();
        REPAIR.addAll(REPAIR_INTERNAL);
        ENCHANTMENTS.addAll(ENCHANTMENTS_INTERNAL);
        REPAIR_ITEMS.addAll(REPAIR_ITEMS_INTERNAL);
        try {
            Ingredient baseItem;
            File file = new File(Paths.get(PATH.toString(), "blatfan/blatapi").toString(), "disabled_vanilla_recipes.json");
            if (!file.exists()) {
                file.createNewFile();
                FileWriter writer = new FileWriter(file);
                JsonObject template = new JsonObject();
                template.addProperty("enable", Boolean.valueOf(true));
                template.add("repair", (JsonElement)new JsonArray());
                template.add("repairItems", (JsonElement)new JsonArray());
                template.add("enchantments", (JsonElement)new JsonArray());
                GSON.toJson((JsonElement)template, (Appendable)writer);
                writer.close();
                return;
            }
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(new FileInputStream(file))).getAsJsonObject();
            if (!GsonHelper.m_13855_((JsonObject)json, (String)"enable", (boolean)true)) {
                return;
            }
            for (JsonElement repairJson : json.get("repair").getAsJsonArray()) {
                Ingredient repairItem = Ingredient.f_43901_;
                if (repairJson.isJsonObject()) {
                    JsonElement baseItemJson = repairJson.getAsJsonObject().get("baseItem");
                    baseItem = baseItemJson.isJsonPrimitive() ? Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)baseItemJson, (String)"baseItem"))}) : CraftingHelper.getIngredient((JsonElement)baseItemJson, (boolean)false);
                    if (repairJson.getAsJsonObject().has("repairItem")) {
                        JsonElement repairItemJson = repairJson.getAsJsonObject().get("repairItem");
                        repairItem = repairItemJson.isJsonPrimitive() ? Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)repairItemJson, (String)"repairItem"))}) : CraftingHelper.getIngredient((JsonElement)repairJson.getAsJsonObject().get("repairItem"), (boolean)true);
                    }
                } else {
                    baseItem = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)repairJson, (String)"baseItem"))});
                }
                REPAIR.add((Pair<Ingredient, Ingredient>)Pair.of((Object)baseItem, (Object)repairItem));
            }
            for (JsonElement enchantmentJson : json.get("enchantments").getAsJsonArray()) {
                Enchantment enchantment;
                baseItem = Ingredient.f_43901_;
                int enchantmentLevel = -1;
                if (enchantmentJson.isJsonObject()) {
                    if (enchantmentJson.getAsJsonObject().has("baseItem")) {
                        JsonElement baseItemJson = enchantmentJson.getAsJsonObject().get("baseItem");
                        baseItem = baseItemJson.isJsonPrimitive() ? Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)baseItemJson, (String)"baseItem"))}) : CraftingHelper.getIngredient((JsonElement)baseItemJson, (boolean)false);
                    }
                    enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)enchantmentJson.getAsJsonObject(), (String)"enchantment")));
                    enchantmentLevel = GsonHelper.m_13824_((JsonObject)enchantmentJson.getAsJsonObject(), (String)"level", (int)-1);
                } else {
                    enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)enchantmentJson.getAsString()));
                }
                ENCHANTMENTS.add((Pair<Pair<Enchantment, Integer>, Ingredient>)Pair.of((Object)Pair.of((Object)enchantment, (Object)enchantmentLevel), (Object)baseItem));
            }
            for (JsonElement repairItemJson : json.get("repairItems").getAsJsonArray()) {
                Ingredient repairItem = repairItemJson.isJsonPrimitive() ? Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)repairItemJson, (String)"repairItem"))}) : CraftingHelper.getIngredient((JsonElement)repairItemJson, (boolean)false);
                REPAIR_ITEMS.add(repairItem);
            }
        }
        catch (IOException e) {
            BlatApi.LOGGER.error(e.getMessage());
        }
    }

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }
}

