/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import ru.blatfan.blatapi.fluffy_fur.client.render.FluffyFurRenderType;
import ru.blatfan.blatapi.fluffy_fur.client.render.RenderBuilder;
import ru.blatfan.blatapi.fluffy_fur.client.render.item.CustomItemRenderer;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurRenderTypes;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.collection.SplitText;

public final class GuiUtil {
    private static CustomItemRenderer customItemRenderer;
    public static float blitOffset;
    public static int FULL_BRIGHT;
    public static Function<Float, Float> FULL_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_IN_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_OUT_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_IN_ROUND_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_OUT_ROUND_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_IN_SEMI_ROUND_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_OUT_SEMI_ROUND_WIDTH_FUNCTION;

    public static GameProfile createOfflineProfile(String playerName) {
        UUID offlineUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes());
        return new GameProfile(offlineUUID, playerName);
    }

    public static void renderFlatPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, String player) {
        GuiUtil.renderFlatPlayerHead(guiGraphics, x, y, size, GuiUtil.createOfflineProfile(player));
    }

    public static void renderFlatPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, GameProfile player) {
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public static void renderFlatPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, Player player) {
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player.m_36316_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public static void render3DPlayerHeadMouse(GuiGraphics guiGraphics, int x, int y, int size, float mouseX, float mouseY, Player player) {
        GuiUtil.render3DPlayerHead(guiGraphics, x, y, size, (mouseX - (float)x) * 0.1f, (mouseY - (float)y) * 0.25f, player);
    }

    public static void render3DPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, float degreeX, float degreeY, Player player) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 100.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(degreeX));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-degreeY));
        GuiUtil.renderPlayerHeadCube(player, poseStack);
        poseStack.m_85849_();
    }

    private static void renderPlayerHeadCube(Player player, PoseStack poseStack) {
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player.m_36316_());
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderType renderType = RenderType.m_110458_((ResourceLocation)skinTexture);
        VertexConsumer buffer = bufferSource.m_6299_(renderType);
        float s = 4.0f;
        int light = 0xF000F0;
        Matrix4f m = poseStack.m_85850_().m_252922_();
        Matrix3f n = poseStack.m_85850_().m_252943_();
        int overlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        float u1 = 0.125f;
        float v1 = 0.125f;
        float u2 = 0.25f;
        float v2 = 0.25f;
        buffer.m_252986_(m, -s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(m, s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(m, s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        u1 = 0.375f;
        v1 = 0.125f;
        u2 = 0.5f;
        v2 = 0.25f;
        buffer.m_252986_(m, s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, -s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        u1 = 0.0f;
        v1 = 0.125f;
        u2 = 0.125f;
        v2 = 0.25f;
        buffer.m_252986_(m, -s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        u1 = 0.25f;
        v1 = 0.125f;
        u2 = 0.375f;
        v2 = 0.25f;
        buffer.m_252986_(m, s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        u1 = 0.25f;
        v1 = 0.0f;
        u2 = 0.375f;
        v2 = 0.125f;
        buffer.m_252986_(m, -s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        u1 = 0.125f;
        v1 = 0.0f;
        u2 = 0.25f;
        v2 = 0.125f;
        buffer.m_252986_(m, -s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferSource.m_109911_();
    }

    public static void renderEntityFollowsMouse(GuiGraphics gui, int x, int y, int scale, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        GuiUtil.renderEntityFollowsAngle(gui, x, y, scale, f, f1, entity);
    }

    public static void renderEntityFollowsAngle(GuiGraphics gui, int x, int y, int scale, float entityLookX, float entityLookY, LivingEntity entity) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(entityLookY * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + entityLookX * 20.0f;
        entity.m_146922_(180.0f + entityLookX * 40.0f);
        entity.m_146926_(-entityLookY * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        GuiUtil.renderEntity(gui, x, y, scale, quaternionf, quaternionf1, entity);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }

    public static void renderEntityQuaternionf(GuiGraphics gui, int x, int y, int scale, Quaternionf quaternionf, Quaternionf quaternionf1, LivingEntity entity) {
        quaternionf.mul((Quaternionfc)quaternionf1);
        GuiUtil.renderEntity(gui, x, y, scale, quaternionf, quaternionf1, entity);
    }

    public static void renderEntity(GuiGraphics gui, int x, int y, int scale, Quaternionf pose, Quaternionf cameraOrientation, LivingEntity entity) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85837_((double)x, (double)y, 50.0);
        gui.m_280168_().m_252931_(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        gui.m_280168_().m_252781_(pose);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        if (cameraOrientation != null) {
            cameraOrientation.conjugate();
            entityrenderdispatcher.m_252923_(cameraOrientation);
        }
        entityrenderdispatcher.m_114468_(false);
        entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, gui.m_280168_(), (MultiBufferSource)gui.m_280091_(), 0xF000F0);
        gui.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        gui.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public static void renderScaledIngredient(GuiGraphics gui, int x, int y, Ingredient ingredient, float scale) {
        ItemStack[] stacks = ingredient.m_43908_();
        if (stacks.length == 0) {
            return;
        }
        int index = (int)(System.currentTimeMillis() / 1000L % (long)stacks.length);
        GuiUtil.renderScaledItem(gui, stacks[index], x, y, scale);
        GuiUtil.renderScaledItemDecorations(gui, stacks[index], x, y, scale);
    }

    public static void renderIngredient(GuiGraphics gui, int x, int y, Ingredient ingredient) {
        GuiUtil.renderScaledIngredient(gui, x, y, ingredient, 1.0f);
    }

    public static void renderTooltip(GuiGraphics gui, int x, int y, Ingredient ingredient, float scale) {
        ItemStack[] stacks = ingredient.m_43908_();
        if (stacks.length == 0) {
            return;
        }
        int index = (int)(System.currentTimeMillis() / 1000L % (long)stacks.length);
        ArrayList<Component> components = new ArrayList<Component>(Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stacks[index]));
        Ingredient.Value value = ingredient.f_43902_[0];
        if (value instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                components.add(1, (Component)Component.m_237113_((String)("Tag: #" + tagValue.f_43959_.f_203868_())).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        GuiUtil.renderScaledTooltip(gui, components, x, y, scale);
    }

    public static void renderTooltip(GuiGraphics gui, int x, int y, Ingredient ingredient) {
        GuiUtil.renderTooltip(gui, x, y, ingredient, 1.0f);
    }

    public static void drawScaledString(GuiGraphics gui, String text, int x, int y, Color color, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.drawString(Minecraft.m_91087_().f_91062_, text, (float)x / size, (float)y / size, ColorHelper.getColor(color), true);
        gui.m_280168_().m_85849_();
    }

    public static void drawScaledString(GuiGraphics gui, Component text, int x, int y, Color color, float size) {
        GuiUtil.drawScaledString(gui, text.getString(), x, y, color, size);
    }

    public static void drawScaledCentreString(GuiGraphics gui, String text, int x, int y, Color color, float size) {
        GuiUtil.drawScaledString(gui, text, x - Minecraft.m_91087_().f_91062_.m_92895_(text) / 2, y, color, size);
    }

    public static void drawScaledCentreString(GuiGraphics gui, Component text, int x, int y, Color color, float size) {
        GuiUtil.drawScaledCentreString(gui, text.getString(), x, y, color, size);
    }

    public static void drawScaledTooltips(GuiGraphics gui, Component text, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280557_(Minecraft.m_91087_().f_91062_, text, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void drawScaledTooltips(GuiGraphics gui, List<Component> text, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280666_(Minecraft.m_91087_().f_91062_, text, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledTooltip(GuiGraphics gui, List<Component> list, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280666_(Minecraft.m_91087_().f_91062_, list, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledItem(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280480_(pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledItemTooltip(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280153_(Minecraft.m_91087_().f_91062_, pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledFakeItem(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280203_(pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledItemDecorations(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280370_(Minecraft.m_91087_().f_91062_, pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, int x, int y, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280159_((int)((float)x / scale), (int)((float)y / scale), pBlitOffset, pWidth, pHeight, pSprite);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, int x, int y, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite, float pRed, float pGreen, float pBlue, float pAlpha) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280565_((int)((float)x / scale), (int)((float)y / scale), pBlitOffset, pWidth, pHeight, pSprite, pRed, pGreen, pBlue, pAlpha);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280218_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pUOffset, pVOffset, pUWidth, pVHeight);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, int pBlitOffset, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280398_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pBlitOffset, pUOffset, pVOffset, pUWidth, pVHeight, pTextureWidth, pTextureHeight);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280411_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pWidth, pHeight, pUOffset, pVOffset, pUWidth, pVHeight, pTextureWidth, pTextureHeight);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280163_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
        pose.m_85849_();
    }

    public static void blitNineSlicedSized(GuiGraphics gui, float scale, ResourceLocation texture, int x, int y, int width, int height, int sliceSize, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.blitNineSlicedSized(texture, (int)((float)x / scale), (int)((float)y / scale), width, height, sliceSize, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        pose.m_85849_();
    }

    public static void blitNineSlicedSized(GuiGraphics gui, float scale, ResourceLocation texture, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.blitNineSlicedSized(texture, (int)((float)x / scale), (int)((float)y / scale), width, height, sliceWidth, sliceHeight, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        pose.m_85849_();
    }

    public static void blitNineSlicedSized(GuiGraphics gui, float scale, ResourceLocation texture, int x, int y, int width, int height, int cornerWidth, int cornerHeight, int edgeWidth, int edgeHeight, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.blitNineSlicedSized(texture, (int)((float)x / scale), (int)((float)y / scale), width, height, cornerWidth, cornerHeight, edgeWidth, edgeHeight, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        pose.m_85849_();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiUtil.drawGradientRect(mat, bufferBuilder, left, top, right, bottom, zLevel, startColor, endColor);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawGradientRect(Matrix4f mat, BufferBuilder bufferBuilder, int left, int top, int right, int bottom, int zLevel, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        bufferBuilder.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        bufferBuilder.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        bufferBuilder.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        bufferBuilder.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
    }

    public static void drawGradientRectHorizontal(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void blit(PoseStack poseStack, int x, int y, int width, int height, float texX, float texY, int texWidth, int texHeight, int fullWidth, int fullHeight) {
        GuiUtil.blit(poseStack, x, x + width, y, y + height, 0, texWidth, texHeight, texX, texY, fullWidth, fullHeight);
    }

    public static void blit(PoseStack poseStack, int x0, int x1, int y0, int y1, int z, int texWidth, int texHeight, float texX, float texY, int fullWidth, int fullHeight) {
        GuiUtil.innerBlit(poseStack, x0, x1, y0, y1, z, (texX + 0.0f) / (float)fullWidth, (texX + (float)texWidth) / (float)fullWidth, (texY + 0.0f) / (float)fullHeight, (texY + (float)texHeight) / (float)fullHeight);
    }

    private static void innerBlit(PoseStack poseStack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)x0, (float)y0, (float)z).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x0, (float)y1, (float)z).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x1, (float)y0, (float)z).m_7421_(u1, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @org.jetbrains.annotations.Nullable Component component, float x, float y, int color, boolean drawShadow) {
        if (component == null) {
            return 0;
        }
        int i = font.m_272077_(component, x, y, color, drawShadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_286081_();
        return i;
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @org.jetbrains.annotations.Nullable String string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        }
        int i = font.m_271703_(string, x, y, color, drawShadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_286081_();
        return i;
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @org.jetbrains.annotations.Nullable FormattedCharSequence string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        }
        int i = font.m_272191_(string, x, y, color, drawShadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_286081_();
        return i;
    }

    public static ShaderInstance getShader(RenderType type) {
        if (type instanceof FluffyFurRenderType) {
            FluffyFurRenderType renderType = (FluffyFurRenderType)type;
            Optional shader = renderType.state.f_173274_.f_173136_;
            if (shader.isPresent()) {
                return (ShaderInstance)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static CustomItemRenderer getCustomItemRenderer() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (customItemRenderer == null) {
            customItemRenderer = new CustomItemRenderer(minecraft, minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), minecraft.m_91291_().getBlockEntityRenderer());
        }
        return customItemRenderer;
    }

    public static void renderItemModelInGui(ItemStack stack, float x, float y, float xSize, float ySize, float zSize) {
        GuiUtil.renderItemModelInGui(stack, x, y, xSize, ySize, zSize, 0.0f, 0.0f, 0.0f, FULL_BRIGHT);
    }

    public static void renderItemModelInGui(ItemStack stack, float x, float y, float xSize, float ySize, float zSize, float xRot, float yRot, float zRot, int packedLight) {
        boolean flag;
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        CustomItemRenderer customItemRenderer = GuiUtil.getCustomItemRenderer();
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 100.0f + blitOffset);
        poseStack.m_85837_((double)xSize / 2.0, (double)ySize / 2.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(xSize, ySize, zSize);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(zRot));
        RenderSystem.applyModelViewMatrix();
        PoseStack pose = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        customItemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)multibuffersource$buffersource, packedLight, OverlayTexture.f_118083_, bakedmodel);
        RenderSystem.disableDepthTest();
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderFloatingItemModelIntoGUI(GuiGraphics gui, ItemStack stack, float x, float y, int packedLight, float ticks, float ticksUp) {
        boolean flag;
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        CustomItemRenderer customItemRenderer = GuiUtil.getCustomItemRenderer();
        float old = bakedmodel.m_7442_().f_111792_.f_111755_.y;
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x + 8.0f, y + 8.0f, 100.0f + (blitOffset += 50.0f));
        pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pose.m_85841_(16.0f, 16.0f, 16.0f);
        pose.m_85837_(0.0, Math.sin(Math.toRadians(ticksUp)) * 0.03125, 0.0);
        if (bakedmodel.m_7547_()) {
            bakedmodel.m_7442_().f_111792_.f_111755_.y = ticks;
        } else {
            pose.m_252781_(Axis.f_252436_.m_252977_(ticks));
        }
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        customItemRenderer.renderItem(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), packedLight, OverlayTexture.f_118083_, bakedmodel);
        RenderSystem.disableDepthTest();
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        pose.m_85849_();
        RenderSystem.applyModelViewMatrix();
        bakedmodel.m_7442_().f_111792_.f_111755_.y = old;
        blitOffset -= 50.0f;
    }

    public static void renderArmorInGui(GuiGraphics gui, ItemStack stack, int x, int y, int z, float sizeX, float sizeY, float sizeZ, float xRot, float yRot, float zRot, int packedLight) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        Minecraft mc = Minecraft.m_91087_();
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)stack);
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(mc.m_91290_(), mc.m_91291_(), mc.m_91289_(), mc.m_91290_().m_234586_(), mc.m_91098_(), mc.m_167973_(), mc.f_91062_);
        ModelPart playerModel = slot == EquipmentSlot.LEGS ? context.m_174023_(ModelLayers.f_171164_) : context.m_174023_(ModelLayers.f_171165_);
        Model model = ForgeHooksClient.getArmorModel((LivingEntity)mc.f_91074_, (ItemStack)stack, (EquipmentSlot)slot, (HumanoidModel)new HumanoidArmorModel(playerModel));
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            humanoidModel.f_102808_.f_104207_ = slot == EquipmentSlot.HEAD;
            humanoidModel.f_102809_.f_104207_ = slot == EquipmentSlot.HEAD;
            humanoidModel.f_102810_.f_104207_ = slot == EquipmentSlot.CHEST;
            humanoidModel.f_102812_.f_104207_ = slot == EquipmentSlot.CHEST;
            humanoidModel.f_102811_.f_104207_ = slot == EquipmentSlot.CHEST;
            humanoidModel.f_102813_.f_104207_ = slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
            humanoidModel.f_102814_.f_104207_ = slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
            humanoidModel.f_102610_ = false;
        }
        float f = -sizeY;
        float f2 = sizeY / 16.0f;
        int yOffset = (int)(f + f2 * (switch (slot) {
            case EquipmentSlot.HEAD -> 4.0f;
            case EquipmentSlot.CHEST -> 14.0f;
            case EquipmentSlot.LEGS -> 24.0f;
            case EquipmentSlot.FEET -> 28.0f;
            default -> 0.0f;
        }));
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x + sizeX / 2.0f, (float)(y - yOffset), (float)z + blitOffset);
        pose.m_85841_(sizeX, sizeY, sizeZ);
        pose.m_252781_(Axis.f_252529_.m_252977_(xRot));
        pose.m_252781_(Axis.f_252436_.m_252977_(yRot));
        pose.m_252781_(Axis.f_252403_.m_252977_(zRot));
        RenderSystem.enableDepthTest();
        Lighting.m_84930_();
        MultiBufferSource.BufferSource bufferSource = gui.m_280091_();
        if (armorItem instanceof DyeableLeatherItem) {
            Color color = new Color(((DyeableLeatherItem)armorItem).m_41121_(stack));
            GuiUtil.renderModel(pose, (MultiBufferSource)bufferSource, packedLight, model, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, RenderType.m_110431_((ResourceLocation)GuiUtil.getArmorResource((Entity)mc.f_91074_, stack, slot, null)));
            GuiUtil.renderModel(pose, (MultiBufferSource)bufferSource, packedLight, model, 1.0f, 1.0f, 1.0f, 1.0f, RenderType.m_110431_((ResourceLocation)GuiUtil.getArmorResource((Entity)mc.f_91074_, stack, slot, "overlay")));
        } else {
            GuiUtil.renderModel(pose, (MultiBufferSource)bufferSource, packedLight, model, 1.0f, 1.0f, 1.0f, 1.0f, RenderType.m_110431_((ResourceLocation)GuiUtil.getArmorResource((Entity)mc.f_91074_, stack, slot, null)));
        }
        ArmorTrim.m_266285_((RegistryAccess)mc.f_91074_.m_9236_().m_9598_(), (ItemStack)stack).ifPresent(trim -> GuiUtil.renderTrim(armorItem.m_40401_(), pose, (MultiBufferSource)bufferSource, packedLight, trim, model));
        if (stack.m_41790_()) {
            GuiUtil.renderGlint(pose, (MultiBufferSource)bufferSource, RenderType.m_110484_(), packedLight, model, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        bufferSource.m_109911_();
        Lighting.m_84931_();
        RenderSystem.disableDepthTest();
        pose.m_85849_();
    }

    public static void renderGlint(PoseStack poseStack, MultiBufferSource buffer, RenderType renderType, int packedLight, Model model, float red, float green, float blue, float alpha) {
        if (red < 0.0f || red > 1.0f) {
            throw new IllegalArgumentException("0<=red<=1, red=" + red);
        }
        if (green < 0.0f || green > 1.0f) {
            throw new IllegalArgumentException("0<=green<=1, green=" + green);
        }
        if (blue < 0.0f || blue > 1.0f) {
            throw new IllegalArgumentException("0<=blue<=1, blue=" + blue);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("0<=alpha<=1, alpha=" + alpha);
        }
        model.m_7695_(poseStack, buffer.m_6299_(renderType), packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        String s1 = GuiUtil.getDefaultArmorPath(stack, slot, type);
        ResourceLocation resourcelocation = (ResourceLocation)HumanoidArmorLayer.f_117070_.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
        }
        return resourcelocation;
    }

    public static String getDefaultArmorPath(ItemStack stack, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String namespace = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            namespace = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        int layer = slot.m_254934_() && slot.equals((Object)EquipmentSlot.LEGS) ? 2 : 1;
        return String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", namespace, texture, layer, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
    }

    public static void renderTrim(ArmorMaterial armorMaterial, PoseStack poseStack, MultiBufferSource buffer, int packedLight, ArmorTrim trim, Model model) {
        TextureAtlas armorTrimAtlas = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_);
        TextureAtlasSprite textureatlassprite = armorTrimAtlas.m_118316_(trim.m_267606_(armorMaterial));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(buffer.m_6299_(Sheets.m_266442_()));
        model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderCustomModel(ModelResourceLocation model, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(model);
        Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)Items.f_42329_), displayContext, leftHand, poseStack, buffer, combinedLight, combinedOverlay, bakedmodel);
    }

    public static void renderBlockModel(ModelResourceLocation model, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BakedModel bakedmodel = Minecraft.m_91087_().m_91304_().m_119422_(model);
        Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)Items.f_42329_), displayContext, leftHand, poseStack, buffer, combinedLight, combinedOverlay, bakedmodel);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resourceLocation);
    }

    public static TextureAtlasSprite getSprite(String modId, String sprite) {
        return GuiUtil.getSprite(new ResourceLocation(modId, sprite));
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light) {
        GuiUtil.renderFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light);
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Color color, boolean flowing, int light) {
        GuiUtil.renderFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light);
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = GuiUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.renderCube(stack, width, height, length);
        }
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Color color, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = GuiUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.setColor(color).renderCube(stack, width, height, length);
        }
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light) {
        GuiUtil.renderCenteredFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light);
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Color color, boolean flowing, int light) {
        GuiUtil.renderCenteredFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light);
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = GuiUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.renderCenteredCube(stack, width, height, length);
        }
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Color color, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = GuiUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.setColor(color).renderCenteredCube(stack, width, height, length);
        }
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light, float strength, float time) {
        GuiUtil.renderWavyFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light, strength, time);
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Color color, boolean flowing, int light, float strength, float time) {
        GuiUtil.renderWavyFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light, strength, time);
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light, float strength, float time) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = GuiUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.renderWavyCube(stack, width, height, length, strength, time);
        }
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Color color, boolean flowing, int light, float strength, float time) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = GuiUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.setColor(color).renderWavyCube(stack, width, height, length, strength, time);
        }
    }

    public static RenderBuilder getFluidRenderBuilder(FluidStack fluidStack, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
        RenderBuilder builder = RenderBuilder.create().setRenderType(FluffyFurRenderTypes.TRANSLUCENT_TEXTURE);
        if (!fluidStack.isEmpty()) {
            FluidType type = fluidStack.getFluid().getFluidType();
            IClientFluidTypeExtensions clientType = IClientFluidTypeExtensions.of((FluidType)type);
            TextureAtlasSprite sprite = GuiUtil.getSprite(clientType.getStillTexture(fluidStack));
            if (flowing) {
                sprite = GuiUtil.getSprite(clientType.getFlowingTexture(fluidStack));
            }
            builder.setFirstUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texLength, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texWidth).setSecondUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texWidth, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texHeight).setThirdUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texLength, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texHeight).setColor(ColorHelper.getColor(clientType.getTintColor(fluidStack))).setLight(Math.max(type.getLightLevel(fluidStack) << 4, light));
        }
        return builder;
    }

    public static void renderConnectLine(PoseStack stack, Vec3 from, Vec3 to, Color color, float alpha) {
        double dX = to.m_7096_() - from.m_7096_();
        double dY = to.m_7098_() - from.m_7098_();
        double dZ = to.m_7094_() - from.m_7094_();
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_((float)Math.toDegrees(-yaw)));
        stack.m_252781_(Axis.f_252403_.m_252977_((float)Math.toDegrees(-pitch) - 180.0f));
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha).renderRay(stack, 0.01f, (float)from.m_82554_(to) + 0.01f);
        stack.m_85849_();
    }

    public static void renderConnectLine(PoseStack stack, BlockPos posFrom, BlockPos posTo, Color color, float alpha) {
        GuiUtil.renderConnectLine(stack, posFrom.m_252807_(), posTo.m_252807_(), color, alpha);
    }

    public static void renderConnectLineOffset(PoseStack stack, Vec3 from, Vec3 to, Color color, float alpha) {
        stack.m_85836_();
        stack.m_85837_(from.m_7096_(), from.m_7098_(), from.m_7094_());
        GuiUtil.renderConnectLine(stack, from, to, color, alpha);
        stack.m_85849_();
    }

    public static void renderConnectBoxLines(PoseStack stack, Vec3 size, Color color, float alpha) {
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, 0.0), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(0.0, 0.0, size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, 0.0, 0.0), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, size.m_7098_(), 0.0), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), size.m_7098_(), 0.0), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, size.m_7098_(), size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, size.m_7098_(), 0.0), new Vec3(size.m_7096_(), size.m_7098_(), 0.0), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), size.m_7098_(), 0.0), new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), new Vec3(0.0, size.m_7098_(), size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, size.m_7098_(), size.m_7094_()), new Vec3(0.0, size.m_7098_(), 0.0), color, alpha);
        stack.m_85836_();
        stack.m_252880_(0.01f, 0.01f, 0.01f);
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha / 8.0f).enableSided().renderCube(stack, (float)size.m_7096_() - 0.02f, (float)size.m_7098_() - 0.02f, (float)size.m_7094_() - 0.02f);
        stack.m_85849_();
    }

    public static void renderConnectSideLines(PoseStack stack, Vec3 size, Color color, float alpha) {
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, 0.0), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(0.0, 0.0, size.m_7094_()), color, alpha);
        GuiUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, 0.0, 0.0), color, alpha);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha / 8.0f).enableSided().renderQuad(stack, (float)size.m_7096_(), (float)size.m_7098_());
        stack.m_85849_();
    }

    public static void renderConnectSide(PoseStack stack, Direction side, Color color, float alpha) {
        Vec3 size = new Vec3(1.0, 1.0, 1.0);
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(side.m_122424_().m_253075_());
        stack.m_252880_(0.0f, -0.001f, 0.0f);
        stack.m_85837_(-size.m_7096_() / 2.0, -size.m_7098_() / 2.0, -size.m_7094_() / 2.0);
        GuiUtil.renderConnectSideLines(stack, size, color, alpha);
        stack.m_85849_();
    }

    public static boolean isFormulaLine(double f, double j, boolean limit, double l) {
        if (limit) {
            return f >= j - l && f <= j + l;
        }
        return false;
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }

    public static Vec2 perpendicularTrailPoints(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / GuiUtil.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static float distance(float ... a) {
        return Mth.m_14116_((float)GuiUtil.distSqr(a));
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static void applyWobble(Vector3f[] offsets, float strength, float gameTime) {
        float offset = 0.0f;
        for (Vector3f vector3f : offsets) {
            double time = (double)(gameTime / 40.0f) % Math.PI * 2.0;
            float sine = Mth.m_14031_((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
            vector3f.add(sine, -sine, 0.0f);
            offset += 0.25f;
        }
    }

    public static void renderModel(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Model model, float red, float green, float blue, float alpha, RenderType renderType) {
        VertexConsumer vertexconsumer = buffer.m_6299_(renderType);
        if (red < 0.0f || red > 1.0f) {
            throw new IllegalArgumentException("0<=red<=1, red=" + red);
        }
        if (green < 0.0f || green > 1.0f) {
            throw new IllegalArgumentException("0<=green<=1, green=" + green);
        }
        if (blue < 0.0f || blue > 1.0f) {
            throw new IllegalArgumentException("0<=blue<=1, blue=" + blue);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("0<=alpha<=1, alpha=" + alpha);
        }
        model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
    }

    public static SplitText splitText(String text, int max, float scale) {
        String[] words;
        SplitText result = new SplitText(scale);
        StringBuilder currentLine = new StringBuilder();
        int currentWidth = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        for (String word : words = text.split(" ")) {
            int wordWidth = (int)((float)font.m_92895_(word + " ") * scale);
            if (word.equals("\n") || currentWidth + wordWidth > max) {
                result.add(currentLine.toString());
                currentWidth = word.equals("\n") ? 0 : wordWidth;
                currentLine = new StringBuilder();
                if (word.equals("\n")) continue;
                currentLine.append(word).append(" ");
                continue;
            }
            currentWidth += wordWidth;
            currentLine.append(word).append(" ");
        }
        return result;
    }

    public static SplitText splitText(String text, int max) {
        return GuiUtil.splitText(text, max, 1.0f);
    }

    public static String toString(List<Component> components) {
        StringBuilder builder = new StringBuilder();
        for (Component component : components) {
            builder.append(component.getString()).append(" \n ");
        }
        return builder.toString();
    }

    private GuiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        blitOffset = 0.0f;
        FULL_BRIGHT = 0xF000F0;
        FULL_WIDTH_FUNCTION = f -> Float.valueOf(1.0f);
        LINEAR_IN_WIDTH_FUNCTION = f -> f;
        LINEAR_OUT_WIDTH_FUNCTION = f -> Float.valueOf(1.0f - f.floatValue());
        LINEAR_IN_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 1.0f ? 0.0f : f.floatValue());
        LINEAR_OUT_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 0.0f ? 0.0f : 1.0f - f.floatValue());
        LINEAR_IN_SEMI_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 1.0f ? 0.5f : f.floatValue());
        LINEAR_OUT_SEMI_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 0.0f ? 0.5f : 1.0f - f.floatValue());
    }
}

