/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.registries.ForgeRegistries;
import ru.blatfan.blatapi.BlatApi;

public final class ItemHelper {
    public static JsonObject serialize(Item item) {
        JsonObject json = new JsonObject();
        json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString());
        return json;
    }

    public static JsonObject serialize(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())).toString());
        if (stack.m_41613_() > 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            json.addProperty("nbt", Objects.requireNonNull(stack.m_41783_()).toString());
        }
        return json;
    }

    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            if (container && stack.hasCraftingRemainingItem()) {
                return stack.getCraftingRemainingItem();
            }
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return ItemHelper.withSize(stack, stack.m_41613_() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack) {
        return ItemHelper.withSize(stack, stack.m_41613_() - 1, false);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && !stack2.m_41619_() && stack1.m_150930_(stack2.m_41720_());
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemHelper.areItemsEqual(stack1, stack2) && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        return ItemHelper.areStacksEqual(stack1, stack2) && stack1.m_41613_() + stack2.m_41613_() <= stack1.m_41741_();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_()) {
            return stack2.m_41777_();
        }
        return ItemHelper.grow(stack1, stack2.m_41613_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCompostable(float chance, ItemLike item) {
        Object2FloatMap object2FloatMap = ComposterBlock.f_51914_;
        synchronized (object2FloatMap) {
            try {
                ComposterBlock.f_51914_.put((Object)item, chance);
            }
            catch (Exception ex) {
                BlatApi.LOGGER.error("Failed to register compostable item: {}, chance {}", (Object)ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()), (Object)Float.valueOf(chance));
            }
        }
    }

    public static List<ItemStack> copyWithNewCount(List<ItemStack> items, int count) {
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        items.forEach(i -> newItems.add(ItemHelper.withSize(i.m_41777_(), count, false)));
        return newItems;
    }

    private ItemHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

