/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import ru.blatfan.blatapi.common.recipe.IRecipePattern;
import ru.blatfan.blatapi.common.recipe.SimpleShapedRecipe;

public final class RecipeUtil {
    public static ItemStack itemStackFromJson(JsonElement pStackElement) {
        return CraftingHelper.getItemStack((JsonObject)pStackElement.getAsJsonObject(), (boolean)true, (boolean)true);
    }

    public static ItemStack itemStackFromJson(JsonObject pStackObject) {
        return CraftingHelper.getItemStack((JsonObject)pStackObject, (boolean)true, (boolean)true);
    }

    public static Item itemFromJson(JsonObject pItemObject) {
        String s = GsonHelper.m_13906_((JsonObject)pItemObject, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return item;
    }

    public static NonNullList<Ingredient> getIngFromJson(JsonObject json) {
        return RecipeUtil.getIngFromJson(json.get("ingredients"));
    }

    public static NonNullList<Ingredient> getIngFromJson(JsonElement ingObject) {
        JsonArray jIngs = ingObject.getAsJsonArray();
        NonNullList ings = NonNullList.m_122780_((int)jIngs.size(), (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41852_}));
        for (int i = 0; i < ings.size(); ++i) {
            ings.set(i, (Object)Ingredient.m_43917_((JsonElement)jIngs.get(i)));
        }
        return ings;
    }

    public static NonNullList<Ingredient> getIngFromNetwork(FriendlyByteBuf buf) {
        NonNullList ings = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41852_}));
        ings.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
        return ings;
    }

    public static void ingsToNetwork(FriendlyByteBuf buf, NonNullList<Ingredient> ingredients) {
        buf.writeInt(ingredients.size());
        for (Object ing : ingredients.toArray()) {
            ((Ingredient)ing).m_43923_(buf);
        }
    }

    public static NonNullList<Ingredient> patternIngsFromJson(JsonObject pJson, int width, int height) {
        Map<String, Ingredient> map = IRecipePattern.keyFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"key"));
        String[] astring = IRecipePattern.shrink(IRecipePattern.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"pattern"), width, height));
        int i = astring[0].length();
        int j = astring.length;
        return IRecipePattern.dissolvePattern(astring, map, i, j);
    }

    public static void patternIngsToNetwork(FriendlyByteBuf buf, SimpleShapedRecipe recipe) {
        buf.writeInt(recipe.getRecipeWidth());
        buf.writeInt(recipe.getRecipeHeight());
        for (Object ing : recipe.m_7527_().toArray()) {
            ((Ingredient)ing).m_43923_(buf);
        }
    }

    public static NonNullList<Ingredient> patternIngFromNetwork(FriendlyByteBuf buf) {
        int i = buf.m_130242_();
        int j = buf.m_130242_();
        NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41852_}));
        for (int k = 0; k < nonnulllist.size(); ++k) {
            nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        return nonnulllist;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)fluidName));
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Unknown fluid " + fluidName);
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        return new FluidStack(fluid, amount);
    }

    public static MobEffectInstance deserializeMobEffect(JsonObject json) {
        String effectName = GsonHelper.m_13906_((JsonObject)json, (String)"effect");
        MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)effectName));
        if (mobEffect == null) {
            throw new JsonSyntaxException("Unknown effect " + effectName);
        }
        int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        int amplifier = GsonHelper.m_13927_((JsonObject)json, (String)"amplifier");
        return new MobEffectInstance(mobEffect, duration, amplifier);
    }

    public static MobEffectInstance mobEffectFromNetwork(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            MobEffect mobEffect = (MobEffect)buffer.readRegistryId();
            int duration = buffer.readInt();
            int amplifier = buffer.readInt();
            return new MobEffectInstance(mobEffect, duration, amplifier);
        }
        return null;
    }

    public static void mobEffectToNetwork(MobEffectInstance effect, FriendlyByteBuf buffer) {
        if (effect == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeRegistryId(ForgeRegistries.MOB_EFFECTS, (Object)effect.m_19544_());
            buffer.writeInt(effect.m_19557_());
            buffer.writeInt(effect.m_19564_());
        }
    }

    public static Enchantment deserializeEnchantment(JsonObject json) {
        String enchantmentName = GsonHelper.m_13906_((JsonObject)json, (String)"enchantment");
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)enchantmentName));
        if (enchantment == null) {
            throw new JsonSyntaxException("Unknown enchantment " + enchantmentName);
        }
        return enchantment;
    }

    public static Enchantment enchantmentFromNetwork(FriendlyByteBuf buffer) {
        return !buffer.readBoolean() ? null : (Enchantment)buffer.readRegistryId();
    }

    public static void enchantmentToNetwork(Enchantment enchantment, FriendlyByteBuf buffer) {
        if (enchantment == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeRegistryId(ForgeRegistries.ENCHANTMENTS, (Object)enchantment);
        }
    }

    private RecipeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

