/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeBuilder {
    protected VoxelShape shapes = Shapes.m_83040_();

    protected VoxelShapeBuilder() {
        this.init();
    }

    protected void init() {
    }

    public static VoxelShapeBuilder create() {
        return new VoxelShapeBuilder();
    }

    public static VoxelShapeBuilder create(final VoxelShape shape) {
        return new VoxelShapeBuilder(){

            @Override
            protected void init() {
                this.add(shape);
            }
        };
    }

    public VoxelShapeBuilder add(VoxelShape add) {
        this.shapes = Shapes.m_83110_((VoxelShape)this.shapes, (VoxelShape)add);
        return this;
    }

    public VoxelShapeBuilder subtract(VoxelShape subtract) {
        this.shapes = Shapes.m_83113_((VoxelShape)this.shapes, (VoxelShape)subtract, (BooleanOp)BooleanOp.f_82685_);
        return this;
    }

    public VoxelShapeBuilder box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.add(Shapes.m_83048_((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0)));
    }

    public VoxelShapeBuilder boxSafe(double x1, double y1, double z1, double x2, double y2, double z2) {
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minY = Math.min(y1, y2);
        double maxY = Math.max(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxZ = Math.max(z1, z2);
        return this.box(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public VoxelShapeBuilder fullBlock() {
        return this.box(0.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    }

    public VoxelShapeBuilder layer(double height) {
        return this.box(0.0, 0.0, 0.0, 16.0, height, 16.0);
    }

    public VoxelShapeBuilder addAll(VoxelShape ... shapes) {
        for (VoxelShape shape : shapes) {
            this.add(shape);
        }
        return this;
    }

    public VoxelShapeBuilder rotate(Direction from, Direction to) {
        this.shapes = VoxelShapeBuilder.rotateShape(from, to, this.shapes);
        return this;
    }

    public VoxelShape build() {
        return this.shapes.m_83296_();
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

