/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils.noise;

import java.util.Random;

public class PerlinNoise {
    private double seed;
    private long default_size;
    private int[] p;
    private int[] permutation;

    public PerlinNoise(double seed) {
        this.seed = seed;
        this.p = new int[512];
        this.permutation = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};
        this.default_size = 35L;
        for (int i = 0; i < 256; ++i) {
            this.p[256 + i] = this.p[i] = this.permutation[i];
        }
    }

    public PerlinNoise() {
        this(new Random().nextGaussian() * 255.0);
    }

    public double noise(double x, double y, double z, int size) {
        double value = 0.0;
        double initialSize = size;
        while (size >= 1) {
            value += this.smoothNoise(x / (double)size, y / (double)size, z / (double)size) * (double)size;
            size = (int)((double)size / 2.0);
        }
        return value / initialSize;
    }

    public double noise(double x, double y, double z) {
        double size;
        double value = 0.0;
        double initialSize = size = (double)this.default_size;
        while (size >= 1.0) {
            value += this.smoothNoise(x / size, y / size, z / size) * size;
            size /= 2.0;
        }
        return value / initialSize;
    }

    public double noise(double x, double y) {
        double size;
        double value = 0.0;
        double initialSize = size = (double)this.default_size;
        while (size >= 1.0) {
            value += this.smoothNoise(x / size, y / size, 0.0 / size) * size;
            size /= 2.0;
        }
        return value / initialSize;
    }

    public double noise(double x) {
        double size;
        double value = 0.0;
        double initialSize = size = (double)this.default_size;
        while (size >= 1.0) {
            value += this.smoothNoise(x / size, 0.0 / size, 0.0 / size) * size;
            size /= 2.0;
        }
        return value / initialSize;
    }

    public double smoothNoise(double x, double y, double z) {
        x += this.seed;
        int X = (int)Math.floor(x += this.seed) & 0xFF;
        int Y = (int)Math.floor(y += this.seed) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = this.fade(x);
        double v = this.fade(y);
        double w = this.fade(z);
        int A = this.p[X] + Y;
        int AA = this.p[A] + Z;
        int AB = this.p[A + 1] + Z;
        int B = this.p[X + 1] + Y;
        int BA = this.p[B] + Z;
        int BB = this.p[B + 1] + Z;
        return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(this.p[AA], x, y, z), this.grad(this.p[BA], x - 1.0, y, z)), this.lerp(u, this.grad(this.p[AB], x, y - 1.0, z), this.grad(this.p[BB], x - 1.0, y - 1.0, z))), this.lerp(v, this.lerp(u, this.grad(this.p[AA + 1], x, y, z - 1.0), this.grad(this.p[BA + 1], x - 1.0, y, z - 1.0)), this.lerp(u, this.grad(this.p[AB + 1], x, y - 1.0, z - 1.0), this.grad(this.p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }
}

