/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public abstract class BlatOverlay
implements IGuiOverlay {
    private static final int HOTBAR_HEIGHT = 32;
    private static final int SCREEN_BORDER_MARGIN = 20;
    private final int DEFAULT_IMAGE_WIDTH;
    private final int IMAGE_HEIGHT;

    protected BlatOverlay(int defaultImageWidth, int imageHeight) {
        this.DEFAULT_IMAGE_WIDTH = defaultImageWidth;
        this.IMAGE_HEIGHT = imageHeight;
    }

    public int getBarX(Anchor anchor, int screenWidth) {
        if (anchor == Anchor.Center) {
            return screenWidth / 2 - this.DEFAULT_IMAGE_WIDTH / 2;
        }
        if (anchor == Anchor.TopLeft || anchor == Anchor.BottomLeft) {
            return 20;
        }
        return screenWidth - 20 - this.DEFAULT_IMAGE_WIDTH;
    }

    public int getBarY(Anchor anchor, int screenHeight) {
        if (anchor == Anchor.Center) {
            return screenHeight - 32 - this.IMAGE_HEIGHT / 2;
        }
        if (anchor == Anchor.TopLeft || anchor == Anchor.TopRight) {
            return 20;
        }
        return screenHeight - 20 - this.IMAGE_HEIGHT;
    }

    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        this.render(screenWidth, screenHeight, forgeGui, guiGraphics, partialTick);
        this.render(screenWidth, screenHeight, guiGraphics, partialTick);
        this.render(screenWidth, screenHeight, guiGraphics);
    }

    public void render(int width, int height, ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTick) {
    }

    public void render(int width, int height, GuiGraphics gui, float partialTick) {
    }

    public void render(int width, int height, GuiGraphics gui) {
    }

    public static enum Anchor {
        Center,
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight;

    }
}

