/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.render.FluidRenderMap;

public class FluidBar
extends AbstractWidget {
    public final ResourceLocation FLUID_WIDGET;
    private final IFluidHandler fluidHandler;
    private final int tank;

    public FluidBar(int pX, int pY, int pWidth, ResourceLocation fluidWidget, IFluidHandler fluidHandler, int tank) {
        super(pX, pY, pWidth, 62 * (pWidth / 16), (Component)Component.m_237113_((String)"Fluid Bar"));
        this.FLUID_WIDGET = fluidWidget;
        this.fluidHandler = fluidHandler;
        this.tank = tank;
    }

    public FluidBar(int pX, int pY, int pWidth, IFluidHandler fluidHandler, int tank) {
        this(pX, pY, pWidth, BlatApi.loc("textures/gui/fluid.png"), fluidHandler, tank);
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.m_252754_() < mouseX && mouseX < this.m_252754_() + this.f_93618_ && this.m_252907_() < mouseY && mouseY < this.m_252907_() + this.m_93694_();
    }

    protected void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float pPartialTick) {
        gui.m_280163_(this.FLUID_WIDGET, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
        if (this.fluidHandler != null && this.fluidHandler.getTankCapacity(this.tank) != 0 && this.fluidHandler.getFluidInTank(this.tank).getAmount() != 0) {
            float capacity = this.fluidHandler.getTankCapacity(this.tank);
            float amount = this.fluidHandler.getFluidInTank(this.tank).getAmount();
            float scale = amount / capacity;
            int fluidAmount = (int)(scale * (float)this.f_93619_);
            TextureAtlasSprite sprite = FluidRenderMap.getCachedFluidTexture(this.fluidHandler.getFluidInTank(this.tank), FluidRenderMap.FluidFlow.STILL);
            if (this.fluidHandler.getFluidInTank(this.tank).getFluid() == Fluids.f_76193_) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            }
            int xPosition = this.m_252754_() + 1;
            int yPosition = this.m_252907_() + 1;
            int maximum = this.f_93619_ - 2;
            int desiredWidth = this.f_93618_ - 2;
            int desiredHeight = fluidAmount - 2;
            gui.m_280159_(xPosition, yPosition + (maximum - desiredHeight), 0, desiredWidth, desiredHeight, sprite);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.isMouseover(mouseX, mouseY)) {
            Object tt = "0mb";
            FluidStack current = this.fluidHandler.getFluidInTank(this.tank);
            if (!current.isEmpty()) {
                tt = current.getAmount() + "mb /" + this.fluidHandler.getTankCapacity(this.tank) + "mb " + current.getDisplayName().getString();
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)tt));
            gui.m_280666_(Minecraft.m_91087_().f_91062_, list, mouseX, mouseY);
        }
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

