/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.guide_book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ru.blatfan.blatapi.api.event.EntryClickedEvent;
import ru.blatfan.blatapi.client.guide_book.GuideBookGui;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.GuideManager;
import ru.blatfan.blatapi.common.guide_book.GuideBookCategory;
import ru.blatfan.blatapi.common.guide_book.GuideBookData;
import ru.blatfan.blatapi.common.guide_book.GuideBookEntry;
import ru.blatfan.blatapi.common.player_stages.PlayerStages;
import ru.blatfan.blatapi.common.task.BookEntryTask;
import ru.blatfan.blatapi.common.task.Task;
import ru.blatfan.blatapi.utils.MathUtils;
import ru.blatfan.blatapi.utils.Text;

public class ResearchScreen
extends Screen {
    private float scale = 1.0f;
    private float targetScale = 1.0f;
    private double offset = 0.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double targetOffset = 0.0;
    private double targetOffsetX = 0.0;
    private double targetOffsetY = 0.0;
    private GuideBookCategory category = null;
    private final int bgSize = 1024;
    private GuideBookGui guideBookGui = null;
    private final GuideBookData data;
    private float screenTick = 0.0f;

    public ResearchScreen(GuideBookData data) {
        super((Component)Component.m_237119_());
        GuideClient.guideBookData = data;
        this.data = data;
    }

    public void m_88315_(GuiGraphics gui, int mX, int mY, float partialTick) {
        this.screenTick += partialTick;
        this.scale = MathUtils.lerp(this.scale, this.targetScale, 0.1f);
        this.offset = MathUtils.lerp(this.offset, this.targetOffset, (double)0.1f);
        this.offsetX = MathUtils.lerp(this.offsetX, this.targetOffsetX, (double)0.1f);
        this.offsetY = MathUtils.lerp(this.offsetY, this.targetOffsetY, (double)0.1f);
        PoseStack pose = gui.m_280168_();
        gui.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        gui.blitNineSlicedSized(this.data.getTexture(), 16, 16, this.f_96543_ - 48, this.f_96544_ - 32, 16, 48, 48, 0, 0, 256, 256);
        if (this.category == null && !this.categories().isEmpty()) {
            this.category = this.categories().get(0);
        } else if (this.category == null) {
            return;
        }
        this.m_280273_(gui);
        this.renderCategories(gui);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85837_((double)((float)this.f_96543_ / 2.0f) + this.offsetX, (double)((float)this.f_96544_ / 2.0f) + this.offsetY, 50.0);
        gui.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        RenderSystem.enableBlend();
        gui.m_280588_(24, 24, this.f_96543_ - 40, this.f_96544_ - 24);
        this.renderConnections(gui);
        this.renderEntries(gui);
        gui.m_280618_();
        RenderSystem.disableBlend();
        pose.m_85849_();
        this.renderTooltips(gui, mX, mY);
        if (this.guideBookGui != null) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 250.0f);
            this.guideBookGui.render(gui, mX, mY, partialTick);
            pose.m_85849_();
            if (this.guideBookGui.isClose()) {
                this.guideBookGui = null;
            }
        }
        pose.m_85836_();
        pose.m_252880_((float)(mX + 4), (float)mY, 500.0f);
        pose.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        gui.m_280218_(this.data.getTexture(), 0, 0, 160, 64, 58, 9);
        pose.m_85849_();
    }

    public void m_280273_(GuiGraphics gui) {
        RenderSystem.enableBlend();
        gui.m_280588_(24, 24, this.f_96543_ - 40, this.f_96544_ - 24);
        for (GuideBookCategory.Background bg : this.category.backgrounds()) {
            this.renderParallaxBG(bg, gui);
        }
        gui.m_280618_();
        RenderSystem.disableBlend();
    }

    private void renderParallaxBG(GuideBookCategory.Background background, GuiGraphics gui) {
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f) + this.offsetX * (double)background.speed(), (double)((float)this.f_96544_ / 2.0f) + this.offsetY * (double)background.speed(), (double)background.sort());
        poseStack.m_85841_(this.scale * (1.0f - background.speed()), this.scale * (1.0f - background.speed()), 1.0f);
        gui.m_280398_(background.texture(), -1536, -1536, 0, 0.0f, 0.0f, 3072, 3072, 3072, 3072);
        poseStack.m_85849_();
    }

    private void renderCategories(GuiGraphics gui) {
        gui.m_280588_(this.f_96543_ - 36, 16, this.f_96543_, this.f_96544_ - 24);
        for (int i = 0; i < this.categories().size(); ++i) {
            GuideBookCategory c = this.categories().get(i);
            int x = this.f_96543_ - 36;
            int y = (int)(16.0 + this.offset) + i * 30;
            gui.blitNineSlicedSized(this.data.getTexture(), x, y, 24, 24, 16, 48, 48, 208, 0, 256, 256);
            gui.m_280203_(c.icon(), x + 4, y + 4);
        }
        gui.m_280618_();
    }

    private List<GuideBookCategory> categories() {
        ArrayList<GuideBookCategory> l = new ArrayList<GuideBookCategory>();
        for (GuideBookCategory c : GuideManager.categories().values()) {
            ResourceLocation book;
            ResourceLocation bookC = c.book();
            if (!bookC.equals((Object)(book = GuideManager.getId(this.data))) || !c.visible(GuideClient.player)) continue;
            l.add(c);
        }
        return l;
    }

    private void renderEntries(GuiGraphics gui) {
        ResourceLocation texture = this.data.getTexture();
        for (GuideBookEntry node : this.entries()) {
            ResourceLocation id = GuideManager.getId(node);
            float a = 1.0f;
            if (!node.completed(GuideClient.player)) {
                a = (float)(Math.sin((double)(this.screenTick % 20.0f / 20.0f) * Math.PI) / 4.0 + 0.75);
            }
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            if (node.advance()) {
                gui.m_280163_(texture, node.x() - 5, node.y() - 5, 74.0f, PlayerStages.get(GuideClient.player, id.toString()) ? 26.0f : 0.0f, 26, 26, 256, 256);
            } else {
                gui.m_280163_(texture, node.x() - 5, node.y() - 5, 48.0f, PlayerStages.get(GuideClient.player, id.toString()) ? 26.0f : 0.0f, 26, 26, 256, 256);
            }
            gui.m_280203_(node.icon(), node.x(), node.y());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    private List<GuideBookEntry> entries() {
        ArrayList<GuideBookEntry> l = new ArrayList<GuideBookEntry>();
        for (GuideBookEntry e : GuideManager.entries().values()) {
            ResourceLocation catE = e.category();
            ResourceLocation cat = GuideManager.getId(this.category);
            if (!e.visible(GuideClient.player) || !catE.equals((Object)cat)) continue;
            l.add(e);
        }
        return l;
    }

    private void renderConnections(GuiGraphics gui) {
        for (GuideBookEntry node : this.entries()) {
            for (Task con : node.view()) {
                BookEntryTask connection;
                if (!(con instanceof BookEntryTask) || (connection = (BookEntryTask)con).getEntry() == null) continue;
                this.renderConnection(gui, node, GuideManager.entries().get(connection.getEntry()));
            }
        }
    }

    private void renderConnection(GuiGraphics graphics, GuideBookEntry from, GuideBookEntry to) {
        ResourceLocation texture = this.data.getTexture();
        graphics.m_280168_().m_85836_();
        double connectionX = from.x() + 8;
        double connectionY = from.y() + 8;
        graphics.m_280168_().m_85837_(connectionX, connectionY, 0.0);
        float rotation = this.getAngleBetween(from, to);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252961_(rotation));
        int length = (int)this.getDistanceBetween(from, to);
        boolean highlighted = to.visible(GuideClient.player);
        graphics.blitNineSlicedSized(texture, 0, -4, length, 8, 8, 99, 8, 100, highlighted ? 0 : 8, 256, 256);
        graphics.m_280168_().m_85849_();
    }

    private float getAngleBetween(GuideBookEntry button1, GuideBookEntry button2) {
        float x1 = button1.x();
        float y1 = button1.y();
        float x2 = button2.x();
        float y2 = button2.y();
        return MathUtils.atan2(y2 - y1, x2 - x1);
    }

    private float getDistanceBetween(GuideBookEntry button1, GuideBookEntry button2) {
        float x1 = button1.x();
        float y1 = button1.y();
        float x2 = button2.x();
        float y2 = button2.y();
        return MathUtils.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public void renderTooltips(GuiGraphics gui, int mouseX, int mouseY) {
        double size;
        double y;
        double x;
        if (this.guideBookGui != null) {
            return;
        }
        ArrayList<Text> list = new ArrayList<Text>();
        for (GuideBookEntry node : this.entries()) {
            x = (double)((float)(node.x() - 5) * this.targetScale) + ((double)this.f_96543_ / 2.0 + this.targetOffsetX);
            y = (double)((float)(node.y() - 5) * this.targetScale) + ((double)this.f_96544_ / 2.0 + this.targetOffsetY);
            size = 26.0f * this.targetScale;
            if (!((double)mouseX >= x) || !((double)mouseX <= x + size) || !((double)mouseY >= y) || !((double)mouseY <= y + size)) continue;
            list.add(Text.create(node.title()).withStyle(ChatFormatting.WHITE));
            list.add(Text.create(node.description()).withStyle(ChatFormatting.GRAY));
            if (!GuideClient.tooltipFlag.m_7050_()) continue;
            list.add(Text.create(GuideManager.getId(node)).withStyle(ChatFormatting.DARK_GRAY));
        }
        for (GuideBookCategory c : this.categories()) {
            x = this.f_96543_ - 36;
            y = (int)(16.0 + this.offset) + this.categories().indexOf(c) * 30;
            size = 24.0;
            if (!((double)mouseX >= x) || !((double)mouseX <= x + size) || !((double)mouseY >= y) || !((double)mouseY <= y + size)) continue;
            list.add(Text.create(c.title()).withColor(c.titleColor()));
            if (!GuideClient.tooltipFlag.m_7050_()) continue;
            list.add(Text.create(GuideManager.getId(c)).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (!list.isEmpty()) {
            gui.m_280666_(this.getMinecraft().f_91062_, list, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        block4: {
            block3: {
                if (this.guideBookGui != null) {
                    return this.guideBookGui.mouseClicked(mouseX, mouseY, button);
                }
                if (!(mouseX > 16.0) || !(mouseX < (double)(this.f_96543_ - 36)) || !(mouseY > 16.0) || !(mouseY < (double)(this.f_96544_ - 24)) || button != 0) break block3;
                for (GuideBookEntry node : this.entries()) {
                    EntryClickedEvent event;
                    double x = (double)((float)(node.x() - 5) * this.targetScale) + ((double)this.f_96543_ / 2.0 + this.targetOffsetX);
                    double y = (double)((float)(node.y() - 5) * this.targetScale) + ((double)this.f_96544_ / 2.0 + this.targetOffsetY);
                    double size = 26.0f * this.targetScale;
                    if (!(mouseX >= x) || !(mouseX <= x + size) || !(mouseY >= y) || !(mouseY <= y + size) || MinecraftForge.EVENT_BUS.post((Event)(event = new EntryClickedEvent(this.data, this.category, node)))) continue;
                    this.guideBookGui = new GuideBookGui(node);
                }
                break block4;
            }
            if (!(mouseX > (double)(this.f_96543_ - 36)) || !(mouseX < (double)this.f_96543_) || !(mouseY > 16.0) || !(mouseY < (double)(this.f_96544_ - 24)) || button != 0) break block4;
            for (GuideBookCategory c : this.categories()) {
                double x = this.f_96543_ - 40;
                double y = (int)(16.0 + this.offset) + this.categories().indexOf(c) * 30;
                double size = 24.0;
                if (!(mouseX >= x) || !(mouseX <= x + size) || !(mouseY >= y) || !(mouseY <= y + size)) continue;
                this.category = c;
                this.targetScale = 1.0f;
                this.targetOffsetX = 0.0;
                this.targetOffsetY = 0.0;
            }
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.guideBookGui != null) {
            return this.guideBookGui.mouseScrolled(mouseX, mouseY, delta);
        }
        if (mouseX > 16.0 && mouseX < (double)(this.f_96543_ - 36) && mouseY > 16.0 && mouseY < (double)(this.f_96544_ - 24)) {
            this.targetScale *= delta > 0.0 ? 1.1f : 0.9f;
            float minScale = 0.4f;
            float maxScale = 1.6f;
            this.targetScale = Math.max(minScale, Math.min(maxScale, this.targetScale));
            return true;
        }
        if (mouseX > (double)(this.f_96543_ - 36) && mouseX < (double)this.f_96543_ && mouseY > 16.0 && mouseY < (double)(this.f_96544_ - 24)) {
            this.targetOffset = Math.max(0.0, Math.min((double)((this.categories().size() - 1) * 30), this.targetOffset - delta * 2.0));
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.guideBookGui != null) {
            return this.guideBookGui.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX > 16.0 && mouseX < (double)(this.f_96543_ - 36) && mouseY > 16.0 && mouseY < (double)(this.f_96544_ - 24) && button == 0) {
            this.targetOffsetX = Math.max(-512.0, Math.min(512.0, this.targetOffsetX + deltaX));
            this.targetOffsetY = Math.max(-512.0, Math.min(512.0, this.targetOffsetY + deltaY));
            return true;
        }
        if (mouseX > (double)(this.f_96543_ - 36) && mouseX < (double)this.f_96543_ && mouseY > 16.0 && mouseY < (double)(this.f_96544_ - 24) && button == 0) {
            this.targetOffset = Math.max(0.0, Math.min((double)((this.categories().size() - 1) * 30), this.targetOffset + deltaY));
            return true;
        }
        return false;
    }

    public void m_7379_() {
        if (this.guideBookGui != null) {
            this.guideBookGui = null;
        } else {
            super.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

