/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.render;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import ru.blatfan.blatapi.client.render.TextureCache;

public class FluidRenderMap<V>
extends Object2ObjectOpenCustomHashMap<FluidStack, V> {
    public FluidRenderMap() {
        super((Hash.Strategy)FluidHashStrategy.INSTANCE);
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack, FluidFlow type) {
        if (fluidStack == null || fluidStack.isEmpty()) {
            return FluidRenderMap.getMissingTexture();
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        if (fluidAttributes == null) {
            return FluidRenderMap.getMissingTexture();
        }
        try {
            ResourceLocation spriteLocation = type == FluidFlow.STILL ? fluidAttributes.getStillTexture(fluidStack) : fluidAttributes.getFlowingTexture(fluidStack);
            if (spriteLocation == null) {
                return FluidRenderMap.getMissingTexture();
            }
            return FluidRenderMap.getSprite(spriteLocation);
        }
        catch (Exception e) {
            Minecraft.m_91087_().m_91307_().m_6182_("fluidTextureError");
            return FluidRenderMap.getMissingTexture();
        }
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        try {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
        }
        catch (Exception e) {
            return FluidRenderMap.getMissingTexture();
        }
    }

    public static TextureAtlasSprite getMissingTexture() {
        try {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft:missingno"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TextureAtlasSprite getCachedFluidTexture(FluidStack fluidStack, FluidFlow type) {
        TextureCache.FluidTextureKey key = TextureCache.createKey(fluidStack, type);
        TextureAtlasSprite cached = TextureCache.get(key);
        if (cached != null) {
            return cached;
        }
        TextureAtlasSprite texture = FluidRenderMap.getFluidTexture(fluidStack, type);
        if (texture != null) {
            TextureCache.put(key, texture);
        }
        return texture;
    }

    public static class FluidHashStrategy
    implements Hash.Strategy<FluidStack> {
        public static final FluidHashStrategy INSTANCE = new FluidHashStrategy();

        public int hashCode(FluidStack stack) {
            if (stack == null || stack.isEmpty()) {
                return 0;
            }
            int code = stack.getFluid().hashCode();
            if (stack.hasTag()) {
                code = 31 * code + stack.getTag().hashCode();
            }
            return code;
        }

        public boolean equals(FluidStack a, FluidStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.isFluidEqual(b);
        }
    }

    public static enum FluidFlow {
        STILL,
        FLOWING;

    }
}

