/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.blatfan.blatapi.client.render.MultiblockPreviewRenderer;
import ru.blatfan.blatapi.common.GuideManager;
import ru.blatfan.blatapi.common.player_stages.PlayerStages;

@Mod.EventBusSubscriber
public class BACommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        PlayerStagesCommands.onRegisterCommands(event);
        MultiblockCommands.onRegisterCommands(event);
    }

    public static class PlayerStagesCommands {
        private static final DynamicCommandExceptionType INVALID_STAGE = new DynamicCommandExceptionType(stage -> Component.m_237110_((String)"argument.blatapi.player_stages.invalid_stage", (Object[])new Object[]{stage}));
        private static final SuggestionProvider<CommandSourceStack> STAGES = (context, builder) -> {
            String input = builder.getRemaining().toLowerCase();
            List<String> allStages = PlayerStages.allStages;
            for (String stage : allStages) {
                if (!stage.toLowerCase().contains(input)) continue;
                builder.suggest(stage);
            }
            return builder.buildFuture();
        };

        public static void onRegisterCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"player_stages").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.word()).suggests(STAGES).executes(PlayerStagesCommands::getStage))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.word()).suggests(STAGES).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PlayerStagesCommands::setStage)))))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(PlayerStagesCommands::listAllStages)))).then(Commands.m_82127_((String)"list").executes(PlayerStagesCommands::listAvailableStages)));
        }

        private static int getStage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Collection players = EntityArgument.m_91477_(context, (String)"player");
            String stage = StringArgumentType.getString(context, (String)"stage");
            if (!PlayerStagesCommands.isValidStage(stage)) {
                throw INVALID_STAGE.create((Object)stage);
            }
            for (ServerPlayer player : players) {
                boolean hasStage = PlayerStages.get((Player)player, stage);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.blatapi.player_stages.get", (Object[])new Object[]{player.m_5446_(), stage, hasStage}), false);
            }
            return players.size();
        }

        private static int setStage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Collection players = EntityArgument.m_91477_(context, (String)"player");
            String stage = StringArgumentType.getString(context, (String)"stage");
            boolean value = BoolArgumentType.getBool(context, (String)"value");
            int count = 0;
            for (ServerPlayer player : players) {
                if (value) {
                    PlayerStages.add((Player)player, stage);
                } else {
                    PlayerStages.remove((Player)player, stage);
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.blatapi.player_stages.set", (Object[])new Object[]{player.m_5446_(), stage, value}), false);
                ++count;
            }
            return count;
        }

        private static int listAllStages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Collection players = EntityArgument.m_91477_(context, (String)"player");
            for (ServerPlayer player : players) {
                Map<String, Boolean> stages = PlayerStages.get((Player)player).getAll();
                if (stages.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.blatapi.player_stages.no_stages", (Object[])new Object[]{player.m_5446_()}), false);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.blatapi.player_stages.list_header", (Object[])new Object[]{player.m_5446_(), stages.size()}), false);
                for (Map.Entry<String, Boolean> entry : stages.entrySet()) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  " + (String)entry.getKey() + ": " + entry.getValue())), false);
                }
            }
            return players.size();
        }

        private static int listAvailableStages(CommandContext<CommandSourceStack> context) {
            List<String> allStages = PlayerStages.allStages;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.blatapi.player_stages.available_stages"), false);
            if (allStages.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  No stages available"), false);
            } else {
                for (String stage : allStages) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  " + stage)), false);
                }
            }
            return allStages.size();
        }

        private static boolean isValidStage(String stage) {
            return PlayerStages.allStages.contains(stage);
        }
    }

    public static class MultiblockCommands {
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"multiblock").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reset").executes(MultiblockCommands::reset))).then(Commands.m_82127_((String)"build").executes(MultiblockCommands::build))).then(Commands.m_82127_((String)"list").executes(MultiblockCommands::list)));
        }

        private static int reset(CommandContext<CommandSourceStack> context) {
            MultiblockPreviewRenderer.setMultiblock(null, (Component)Component.m_237119_(), false);
            return 1;
        }

        private static int list(CommandContext<CommandSourceStack> context) {
            ArrayList list = new ArrayList();
            GuideManager.multiblocks().keySet().forEach(id -> list.add(id.toString()));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.blatapi.player_stages.available_multiblocks"), false);
            if (list.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  No multiblocks available"), false);
            } else {
                for (String m : list) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  " + m)), false);
                }
            }
            return list.size();
        }

        private static int build(CommandContext<CommandSourceStack> context) {
            return MultiblockPreviewRenderer.buildMultiblock(((CommandSourceStack)context.getSource()).m_81372_());
        }
    }
}

