/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.cap;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage
implements INBTSerializable<Tag> {
    public final String tag;

    public CustomEnergyStorage(int capacity, int maxTransfer, String tag) {
        super(capacity, maxTransfer);
        this.tag = tag;
    }

    public CustomEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, "energy");
    }

    public CustomEnergyStorage(int capacity) {
        this(capacity, capacity / 4, "energy");
    }

    public CustomEnergyStorage(int capacity, String tag) {
        this(capacity, capacity / 4, tag);
    }

    public void setEnergy(int energyIn) {
        if (energyIn < 0) {
            energyIn = 0;
        }
        if (energyIn > this.getMaxEnergyStored()) {
            energyIn = this.getEnergyStored();
        }
        this.energy = energyIn;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(this.tag, this.getEnergyStored());
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        CompoundTag real = (CompoundTag)nbt;
        this.setEnergy(real.m_128451_(this.tag));
    }
}

