/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.cap;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import ru.blatfan.blatapi.common.cap.CustomEnergyStorage;

public class FloatEnergyStorage
extends CustomEnergyStorage {
    private int originalCapacity;
    private int originalMaxReceive;
    private int originalMaxExtract;

    public FloatEnergyStorage(int capacity, int maxTransfer, String tag) {
        super(capacity, maxTransfer, tag);
        this.originalCapacity = capacity;
        this.originalMaxReceive = maxTransfer;
        this.originalMaxExtract = maxTransfer;
    }

    public FloatEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, "energy");
    }

    public FloatEnergyStorage(int capacity, String tag) {
        this(capacity, capacity / 4, tag);
    }

    public FloatEnergyStorage(int capacity) {
        this(capacity, capacity / 4);
    }

    public void setCapacity(int newCapacity) {
        this.capacity = newCapacity;
    }

    public void setMaxReceive(int newMaxReceive) {
        this.maxReceive = newMaxReceive;
    }

    public void setMaxExtract(int newMaxExtract) {
        this.maxExtract = newMaxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("capacity", this.capacity);
        tag.m_128405_("originalCapacity", this.originalCapacity);
        tag.m_128405_("maxReceive", this.maxReceive);
        tag.m_128405_("originalMaxReceive", this.originalMaxReceive);
        tag.m_128405_("maxExtract", this.maxExtract);
        tag.m_128405_("originalMaxExtract", this.originalMaxExtract);
        return tag;
    }

    @Override
    public void deserializeNBT(Tag nbt) {
        super.deserializeNBT(nbt);
        CompoundTag tag = (CompoundTag)nbt;
        this.capacity = tag.m_128451_("capacity");
        this.originalCapacity = tag.m_128451_("originalCapacity");
        this.maxReceive = tag.m_128451_("maxReceive");
        this.originalMaxReceive = tag.m_128451_("originalMaxReceive");
        this.maxExtract = tag.m_128451_("maxExtract");
        this.originalMaxExtract = tag.m_128451_("originalMaxExtract");
    }

    public int getOriginalCapacity() {
        return this.originalCapacity;
    }

    public int getOriginalMaxReceive() {
        return this.originalMaxReceive;
    }

    public int getOriginalMaxExtract() {
        return this.originalMaxExtract;
    }
}

