/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.cap.item;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import ru.blatfan.blatapi.common.cap.FloatEnergyStorage;
import ru.blatfan.blatapi.utils.NBTHelper;

public class FloatEnergyCapabilityItemStack
implements ICapabilityProvider {
    private final LazyOptional<IEnergyStorage> energy;
    private final int originalCapacity;
    private final ItemStack stack;

    private IEnergyStorage createEnergy() {
        return new FloatEnergyStorage(this.originalCapacity){

            private CompoundTag getTag() {
                return NBTHelper.getTagCompound(FloatEnergyCapabilityItemStack.this.stack, this.tag);
            }

            public int getEnergyStored() {
                return this.getTag().m_128451_("energy");
            }

            @Override
            public void setEnergy(int energy) {
                this.getTag().m_128405_("energy", energy);
                super.setEnergy(energy);
            }

            @Override
            public void setCapacity(int newCapacity) {
                this.getTag().m_128405_("capacity", newCapacity);
                this.capacity = newCapacity;
            }

            @Override
            public void setMaxReceive(int newMaxReceive) {
                this.getTag().m_128405_("maxReceive", newMaxReceive);
                this.maxReceive = newMaxReceive;
            }

            @Override
            public void setMaxExtract(int newMaxExtract) {
                this.getTag().m_128405_("maxExtract", newMaxExtract);
                this.maxExtract = newMaxExtract;
            }

            @Override
            public int getMaxReceive() {
                return this.getTag().m_128451_("maxReceive");
            }

            @Override
            public int getMaxExtract() {
                return this.getTag().m_128451_("maxExtract");
            }
        };
    }

    public FloatEnergyCapabilityItemStack(ItemStack stack, int capacity) {
        this.originalCapacity = capacity;
        this.stack = stack;
        this.energy = LazyOptional.of(this::createEnergy);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (ForgeCapabilities.ENERGY == capability) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }
}

