/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.utils.RecipeUtil;
import ru.blatfan.blatapi.utils.Text;

public class GuideBookData {
    private final ResourceLocation texture;
    private final Component title;
    private final Component author;
    private final Color titleColor;
    private final ItemStack pedestal;
    private final Component tooltip;
    private final ResourceLocation model;

    public static GuideBookData json(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        ResourceLocation texture = ResourceLocation.m_135820_((String)json.get("texture").getAsString());
        MutableComponent title = Text.create(json.get("title").getAsString()).asComponent();
        Text author = Text.create(json.get("author").getAsString());
        Color titleColor = Color.decode(json.get("title_color").getAsString());
        ItemStack pedestal = json.has("pedestal") ? RecipeUtil.itemStackFromJson(json.get("pedestal")) : ItemStack.f_41583_;
        MutableComponent tooltip = json.has("tooltip") ? Text.create(json.get("tooltip").getAsString()) : Component.m_237119_();
        ResourceLocation model = json.has("model") ? ResourceLocation.m_135820_((String)json.get("model").getAsString()) : BlatApi.loc("guide_book");
        return new GuideBookData(texture, (Component)title, author, titleColor, pedestal, (Component)tooltip, model);
    }

    public GuideBookData(ResourceLocation texture, Component title, Component author, Color titleColor, ItemStack pedestal, Component tooltip, ResourceLocation model) {
        this.texture = texture;
        this.title = title;
        this.author = author;
        this.titleColor = titleColor;
        this.pedestal = pedestal;
        this.tooltip = tooltip;
        this.model = model;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getAuthor() {
        return this.author;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public ItemStack getPedestal() {
        return this.pedestal;
    }

    public Component getTooltip() {
        return this.tooltip;
    }

    public ResourceLocation getModel() {
        return this.model;
    }
}

