/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.ForgeEventFactory;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.guide_book.pages.EmptyPage;
import ru.blatfan.blatapi.utils.RecipeUtil;
import ru.blatfan.blatapi.utils.Text;

public abstract class GuideBookPage {
    private static final Map<ResourceLocation, Function<JsonObject, GuideBookPage>> TYPES = new HashMap<ResourceLocation, Function<JsonObject, GuideBookPage>>();
    private final Component title;
    private final Color titleColor;
    private final boolean separator;
    private final List<RenderItem> renderItems = new ArrayList<RenderItem>();

    public static void addPageType(ResourceLocation type, Function<JsonObject, GuideBookPage> deserialize) {
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, deserialize);
        }
    }

    public GuideBookPage(Component title, Color titleColor, boolean separator) {
        this.title = title;
        this.titleColor = titleColor;
        this.separator = separator;
    }

    public int getHeight() {
        return this.height() + (!this.renderItems.isEmpty() ? this.renderItems.size() % 5 * 18 : 0);
    }

    protected abstract int height();

    public void renderPage(GuiGraphics gui, int x, int y, int mX, int mY, float partialTick) {
        Font font = GuideClient.font;
        if (this.separator) {
            gui.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
            int xs = GuideClient.pageWidth / 2 - font.m_92852_((FormattedText)this.getTitle()) / 2 - 4;
            ResourceLocation resourceLocation = GuideClient.guideBookData.getTexture();
            Objects.requireNonNull(font);
            gui.blitNineSlicedSized(resourceLocation, x + 8, y + 9 / 2, xs - 8, 4, 8, 24, 4, 144, 32, 256, 256);
            ResourceLocation resourceLocation2 = GuideClient.guideBookData.getTexture();
            int n = x + 8 + xs + font.m_92852_((FormattedText)this.getTitle());
            Objects.requireNonNull(font);
            gui.blitNineSlicedSized(resourceLocation2, n, y + 9 / 2, xs, 4, 8, 24, 4, 144, 32, 256, 256);
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        gui.m_280653_(font, this.getTitle(), x + GuideClient.pageWidth / 2, y, this.getTitleColor().getRGB());
        Objects.requireNonNull(font);
        this.render(gui, x, y + 9 + 2, mX, mY, partialTick);
        for (int i = 0; i < this.renderItems.size(); ++i) {
            int column = i % 7;
            int row = i / 7;
            if (this.height() + row * 18 > GuideClient.pageHeight) {
                return;
            }
            this.renderItems.get(i).render(gui, x + 4 + column * 18, y + this.height() + row * 18, mX, mY);
        }
    }

    protected abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    public boolean mouseClicked(double mX, double mY, int button) {
        return false;
    }

    public static GuideBookPage json(JsonElement element) {
        EmptyPage page;
        JsonObject json = element.getAsJsonObject();
        ResourceLocation type = ResourceLocation.m_135820_((String)json.get("type").getAsString());
        GuideBookPage guideBookPage = page = TYPES.containsKey(type) ? TYPES.get(type).apply(json) : new EmptyPage();
        if (json.has("item_page")) {
            for (JsonElement el : json.get("item_page").getAsJsonArray()) {
                page.renderItems.add(RenderItem.deserialize(el));
            }
        }
        return page;
    }

    public Component getTitle() {
        return this.title;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public List<RenderItem> getRenderItems() {
        return this.renderItems;
    }

    private record RenderItem(ItemStack stack, boolean pedestal, List<Component> tooltips) {
        public static RenderItem deserialize(JsonElement element) {
            JsonObject json = element.getAsJsonObject();
            ItemStack stack = RecipeUtil.itemStackFromJson(json);
            ArrayList<Component> tooltips = new ArrayList<Component>();
            if (json.has("tooltips")) {
                for (JsonElement el : json.get("tooltips").getAsJsonArray()) {
                    tooltips.add(Text.create(el.getAsString()));
                }
            }
            boolean pedestal = !json.has("pedestal") || json.get("pedestal").getAsBoolean();
            return new RenderItem(stack, pedestal, tooltips);
        }

        public void render(GuiGraphics gui, int x, int y, int mX, int mY) {
            Font font = GuideClient.mc.f_91062_;
            if (this.pedestal) {
                gui.m_280168_().m_85836_();
                gui.m_280168_().m_252880_(0.0f, 0.0f, -50.0f);
                gui.m_280203_(GuideClient.guideBookData.getPedestal(), x, y + 6);
                gui.m_280168_().m_85849_();
            }
            gui.m_280480_(this.stack, x, y);
            gui.m_280370_(font, this.stack, x, y);
            if (mX >= x && mX <= x + 16 && mY >= y && mY <= y + 16) {
                boolean v = false;
                ArrayList<Component> s = new ArrayList<Component>(this.tooltips);
                for (Component c : s) {
                    if (!c.getString().equals("item_tooltips")) continue;
                    v = true;
                    s.remove(c);
                }
                gui.m_280666_(font, this.getTooltipLines(this.stack, s, v, GuideClient.player, GuideClient.tooltipFlag), mX, mY);
            }
        }

        private List<Component> getTooltipLines(ItemStack stack, List<Component> addition, boolean vanilla, Player pPlayer, TooltipFlag pIsAdvanced) {
            Integer integer;
            ArrayList list = Lists.newArrayList();
            MutableComponent mutablecomponent = Component.m_237119_().m_7220_(stack.m_41786_()).m_130938_(stack.m_41791_().getStyleModifier());
            if (stack.m_41788_()) {
                mutablecomponent.m_130940_(ChatFormatting.ITALIC);
            }
            list.add(mutablecomponent);
            if (!pIsAdvanced.m_7050_() && !stack.m_41788_() && stack.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_((ItemStack)stack)) != null) {
                list.add(Component.m_237113_((String)("#" + integer)).m_130940_(ChatFormatting.GRAY));
            }
            int j = stack.m_41618_();
            if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.ADDITIONAL) && vanilla) {
                stack.m_41720_().m_7373_(stack, pPlayer == null ? null : pPlayer.m_9236_(), (List)list, pIsAdvanced);
            }
            if (stack.m_41782_()) {
                if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.UPGRADES) && pPlayer != null && vanilla) {
                    ArmorTrim.m_266563_((ItemStack)stack, (RegistryAccess)pPlayer.m_9236_().m_9598_(), (List)list);
                }
                if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.ENCHANTMENTS) && vanilla) {
                    ItemStack.m_41709_((List)list, (ListTag)stack.m_41785_());
                }
                if (stack.m_41783_().m_128425_("display", 10)) {
                    CompoundTag compoundtag = stack.m_41783_().m_128469_("display");
                    if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.DYE) && compoundtag.m_128425_("color", 99) && vanilla) {
                        if (pIsAdvanced.m_7050_()) {
                            list.add(Component.m_237110_((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", compoundtag.m_128451_("color"))}).m_130940_(ChatFormatting.GRAY));
                        } else {
                            list.add(Component.m_237115_((String)"item.dyed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                        }
                    }
                    if (compoundtag.m_128435_("Lore") == 9) {
                        ListTag listtag = compoundtag.m_128437_("Lore", 8);
                        if (vanilla) {
                            for (int i = 0; i < listtag.size(); ++i) {
                                String s = listtag.m_128778_(i);
                                try {
                                    MutableComponent mutablecomponent1 = Component.Serializer.m_130701_((String)s);
                                    if (mutablecomponent1 == null) continue;
                                    list.add(ComponentUtils.m_130750_((MutableComponent)mutablecomponent1, (Style)ItemStack.f_41586_));
                                    continue;
                                }
                                catch (Exception exception) {
                                    compoundtag.m_128473_("Lore");
                                }
                            }
                        }
                    }
                }
            }
            list.addAll(addition);
            if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.MODIFIERS) && vanilla) {
                for (CompoundTag equipmentslot : EquipmentSlot.values()) {
                    Multimap multimap = stack.m_41638_((EquipmentSlot)equipmentslot);
                    if (multimap.isEmpty()) continue;
                    list.add(CommonComponents.f_237098_);
                    list.add(Component.m_237115_((String)("item.modifiers." + equipmentslot.m_20751_())).m_130940_(ChatFormatting.GRAY));
                    for (Map.Entry entry : multimap.entries()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double d0 = attributemodifier.m_22218_();
                        boolean flag = false;
                        if (pPlayer != null) {
                            if (attributemodifier.m_22209_() == Item.f_41374_) {
                                d0 += pPlayer.m_21172_(Attributes.f_22281_);
                                d0 += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                                flag = true;
                            } else if (attributemodifier.m_22209_() == Item.f_41375_) {
                                d0 += pPlayer.m_21172_(Attributes.f_22283_);
                                flag = true;
                            }
                        }
                        double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
                        if (flag) {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = ItemStack.f_41584_.format(d1);
                            objectArray[1] = Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_());
                            list.add(CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.m_22217_().m_22235_()), (Object[])objectArray)).m_130940_(ChatFormatting.DARK_GREEN));
                            continue;
                        }
                        if (d0 > 0.0) {
                            list.add(Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        list.add(Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
                    }
                }
            }
            if (stack.m_41782_() && vanilla) {
                ListTag listtag2;
                ListTag listtag1;
                if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.UNBREAKABLE) && stack.m_41783_().m_128471_("Unbreakable")) {
                    list.add(Component.m_237115_((String)"item.unbreakable").m_130940_(ChatFormatting.BLUE));
                }
                if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.CAN_DESTROY) && stack.m_41783_().m_128425_("CanDestroy", 9) && vanilla && !(listtag1 = stack.m_41783_().m_128437_("CanDestroy", 8)).isEmpty()) {
                    list.add(CommonComponents.f_237098_);
                    list.add(Component.m_237115_((String)"item.canBreak").m_130940_(ChatFormatting.GRAY));
                    for (int k = 0; k < listtag1.size(); ++k) {
                        list.addAll(ItemStack.m_41761_((String)listtag1.m_128778_(k)));
                    }
                }
                if (ItemStack.m_41626_((int)j, (ItemStack.TooltipPart)ItemStack.TooltipPart.CAN_PLACE) && stack.m_41783_().m_128425_("CanPlaceOn", 9) && vanilla && !(listtag2 = stack.m_41783_().m_128437_("CanPlaceOn", 8)).isEmpty()) {
                    list.add(CommonComponents.f_237098_);
                    list.add(Component.m_237115_((String)"item.canPlace").m_130940_(ChatFormatting.GRAY));
                    for (int l = 0; l < listtag2.size(); ++l) {
                        list.addAll(ItemStack.m_41761_((String)listtag2.m_128778_(l)));
                    }
                }
            }
            if (stack.m_41768_()) {
                list.add(Component.m_237110_((String)"item.durability", (Object[])new Object[]{stack.m_41776_() - stack.m_41773_(), stack.m_41776_()}));
            }
            if (pIsAdvanced.m_7050_()) {
                list.add(Component.m_237113_((String)BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
                if (stack.m_41782_()) {
                    list.add(Component.m_237110_((String)"item.nbt_tags", (Object[])new Object[]{stack.m_41783_().m_128431_().size()}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            if (pPlayer != null && !stack.m_41720_().m_245993_(pPlayer.m_9236_().m_246046_())) {
                list.add(ItemStack.f_243862_);
            }
            ForgeEventFactory.onItemTooltip((ItemStack)stack, (Player)pPlayer, (List)list, (TooltipFlag)pIsAdvanced);
            return list;
        }
    }
}

