/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book.pages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.guide_book.GuideBookPage;
import ru.blatfan.blatapi.common.guide_book.pages.TextPage;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.SplitText;
import ru.blatfan.blatapi.utils.Text;

public class ImagePage
extends GuideBookPage {
    public static final ResourceLocation TYPE = BlatApi.loc("image");
    private final ResourceLocation image;
    private final int imageWidth;
    private final int imageHeight;
    private final Color color;
    private final SplitText texts;

    public ImagePage(Component title, Color titleColor, boolean separator, ResourceLocation image, int imageWidth, int imageHeight, Color color, List<Component> text) {
        super(title, titleColor, separator);
        this.image = image;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.color = color;
        this.texts = !text.isEmpty() ? TextPage.splitText(text, GuideClient.pageWidth - 12, GuideClient.pageHeight - 10 - this.imageHeight) : new SplitText(1.0f);
    }

    public static GuideBookPage json(JsonObject jsonObject) {
        ArrayList<Component> text = new ArrayList<Component>();
        for (JsonElement element : jsonObject.getAsJsonArray("text")) {
            text.add(Text.create(element.getAsString()));
        }
        return new ImagePage(Text.create(jsonObject.get("title").getAsString()), jsonObject.has("title_color") ? ColorHelper.getColor(jsonObject.get("title_color").getAsString()) : Color.WHITE, jsonObject.has("separator") && jsonObject.get("separator").getAsBoolean(), ResourceLocation.m_135820_((String)jsonObject.get("image").getAsString()), jsonObject.get("image_width").getAsInt(), jsonObject.has("image_height") ? jsonObject.get("image_height").getAsInt() : jsonObject.get("image_width").getAsInt(), jsonObject.has("color") ? ColorHelper.getColor(jsonObject.get("color").getAsString()) : Color.WHITE, text);
    }

    @Override
    protected int height() {
        return this.imageHeight + this.texts.height();
    }

    @Override
    protected void render(GuiGraphics gui, int x, int y, int mX, int mY, float partialTick) {
        Font font = GuideClient.font;
        float sc = (float)(GuideClient.pageWidth - 8) / (float)this.imageWidth;
        GuiUtil.blit(gui, sc, this.image, x + 10, y + 1, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        for (int i = 0; i < this.texts.size(); ++i) {
            String c = (String)this.texts.get(i);
            float f = (float)this.imageHeight * sc + (float)y + 2.0f;
            Objects.requireNonNull(font);
            int ty = (int)(f + (float)(9 * i));
            GuiUtil.drawScaledString(gui, c, x + 4, ty, this.color, this.texts.scale());
        }
    }
}

