/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book.pages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.client.guide_book.recipe_renderers.EmptyRecipeRenderer;
import ru.blatfan.blatapi.client.guide_book.recipe_renderers.RecipeRenderer;
import ru.blatfan.blatapi.common.guide_book.GuideBookPage;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.RecipeHelper;
import ru.blatfan.blatapi.utils.Text;

public class RecipePage
extends GuideBookPage {
    public static final ResourceLocation TYPE = BlatApi.loc("recipe");
    private static final Map<ResourceLocation, RecipeRenderer> TYPES = new HashMap<ResourceLocation, RecipeRenderer>();
    private final List<ResourceLocation> recipeIds;
    private final int height;

    public static void addRecipeType(ResourceLocation recipeType, RecipeRenderer recipeRenderer) {
        if (!TYPES.containsKey(recipeType)) {
            TYPES.put(recipeType, recipeRenderer);
        }
    }

    public RecipePage(List<ResourceLocation> recipeIds, boolean separator, Component title, Color titleColor) {
        super(title, titleColor, separator);
        this.recipeIds = recipeIds;
        int h = 11;
        for (int i = 0; i < recipeIds.size(); ++i) {
            RecipeRenderer rr = RecipePage.getRecipeRenderer(this.getRecipeType(i));
            if (rr == null) {
                rr = EmptyRecipeRenderer.INSTANCE;
            }
            h += (int)((float)rr.height() / rr.scale()) + 2;
        }
        this.height = h;
    }

    protected static RecipeRenderer getRecipeRenderer(ResourceLocation type) {
        if (TYPES.containsKey(type)) {
            return TYPES.get(type);
        }
        return EmptyRecipeRenderer.INSTANCE;
    }

    public Recipe<?> getRecipe(int i) {
        return RecipeHelper.getRecipe(this.recipeIds.get(i));
    }

    public ResourceLocation getRecipeType(int i) {
        if (this.getRecipe(i) == null) {
            return new ResourceLocation("null");
        }
        return ResourceLocation.m_135820_((String)this.getRecipe(i).m_6671_().toString());
    }

    public static GuideBookPage json(JsonObject jsonObject) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (JsonElement el : jsonObject.get("recipes").getAsJsonArray()) {
            ids.add(ResourceLocation.m_135820_((String)el.getAsString()));
        }
        return new RecipePage(ids, jsonObject.has("separator") && jsonObject.get("separator").getAsBoolean(), Text.create(jsonObject.get("title").getAsString()), jsonObject.has("title_color") ? ColorHelper.getColor(jsonObject.get("title_color").getAsString()) : Color.WHITE);
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mX, int mY, float partialTick) {
        int h = 0;
        for (int i = 0; i < this.recipeIds.size(); ++i) {
            RecipeRenderer rr = RecipePage.getRecipeRenderer(this.getRecipeType(i));
            if (rr == null) {
                rr = EmptyRecipeRenderer.INSTANCE;
            }
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_85841_(rr.scale(), rr.scale(), 1.0f);
            rr.render(this.getRecipe(i), gui, (int)(((float)x + (float)GuideClient.pageWidth / 2.0f - (float)rr.width() / 2.0f) * rr.scale()), (int)((float)(y + h) / rr.scale()), mX, mY, partialTick);
            gui.m_280168_().m_85849_();
            gui.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
            gui.blitNineSlicedSized(GuideClient.guideBookData.getTexture(), x + 8, y + (h += (int)((float)rr.height() / rr.scale()) + 2) - 4, GuideClient.pageWidth - 10, 4, 8, 24, 4, 144, 32, 256, 256);
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

