/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.multiblock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.api.multiblock.Multiblock;
import ru.blatfan.blatapi.api.multiblock.StateMatcher;
import ru.blatfan.blatapi.common.multiblock.AbstractMultiblock;
import ru.blatfan.blatapi.common.multiblock.SimulateResultImpl;
import ru.blatfan.blatapi.common.multiblock.matcher.Matchers;

public class SparseMultiblock
extends AbstractMultiblock {
    public static final ResourceLocation TYPE = BlatApi.loc("sparse");
    private final Map<BlockPos, StateMatcher> stateMatchers;
    private final Vec3i size;

    public SparseMultiblock(Map<BlockPos, StateMatcher> stateMatchers) {
        Preconditions.checkArgument((!stateMatchers.isEmpty() ? 1 : 0) != 0, (Object)"No data given to sparse multiblock!");
        this.stateMatchers = ImmutableMap.copyOf(stateMatchers);
        this.size = this.calculateSize();
    }

    public static SparseMultiblock fromJson(JsonObject json) {
        JsonObject jsonMapping = GsonHelper.m_13930_((JsonObject)json, (String)"mapping");
        Map<Character, StateMatcher> mapping = SparseMultiblock.mappingFromJson(jsonMapping);
        JsonObject jsonPattern = GsonHelper.m_13930_((JsonObject)json, (String)"pattern");
        Object2ObjectOpenHashMap stateMatchers = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : jsonPattern.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Pattern key needs to be only 1 character");
            }
            StateMatcher matcher = mapping.get(Character.valueOf(((String)entry.getKey()).charAt(0)));
            JsonArray jsonPositions = GsonHelper.m_13924_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
            for (JsonElement jsonPosition : jsonPositions) {
                JsonArray jsonPos = GsonHelper.m_13924_((JsonElement)jsonPosition, (String)((String)entry.getKey()));
                if (jsonPos.size() != 3) {
                    throw new JsonSyntaxException("Each matcher position needs to be an array of 3 integers");
                }
                stateMatchers.put(new BlockPos(jsonPos.get(0).getAsInt(), jsonPos.get(1).getAsInt(), jsonPos.get(2).getAsInt()), matcher);
            }
        }
        SparseMultiblock multiblock = new SparseMultiblock((Map<BlockPos, StateMatcher>)stateMatchers);
        return SparseMultiblock.additionalPropertiesFromJson(multiblock, json);
    }

    private Vec3i calculateSize() {
        int minX = this.stateMatchers.keySet().stream().mapToInt(Vec3i::m_123341_).min().getAsInt();
        int maxX = this.stateMatchers.keySet().stream().mapToInt(Vec3i::m_123341_).max().getAsInt();
        int minY = this.stateMatchers.keySet().stream().mapToInt(Vec3i::m_123342_).min().getAsInt();
        int maxY = this.stateMatchers.keySet().stream().mapToInt(Vec3i::m_123342_).max().getAsInt();
        int minZ = this.stateMatchers.keySet().stream().mapToInt(Vec3i::m_123343_).min().getAsInt();
        int maxZ = this.stateMatchers.keySet().stream().mapToInt(Vec3i::m_123343_).max().getAsInt();
        return new Vec3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
    }

    @Override
    public Vec3i getSize() {
        return this.size;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Pair<BlockPos, Collection<Multiblock.SimulateResult>> simulate(Level world, BlockPos anchor, Rotation rotation, boolean forView, boolean disableOffset) {
        BlockPos disp;
        BlockPos blockPos = disp = forView ? new BlockPos(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).m_7954_(rotation) : new BlockPos(-this.offX, -this.offY, -this.offZ).m_7954_(rotation);
        if (disableOffset) {
            disp = BlockPos.f_121853_;
        }
        BlockPos origin = anchor.m_121955_((Vec3i)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (Map.Entry<BlockPos, StateMatcher> e : this.stateMatchers.entrySet()) {
            BlockPos currDisp = e.getKey().m_7954_(rotation);
            BlockPos actionPos = origin.m_121955_((Vec3i)currDisp);
            ret.add(new SimulateResultImpl(actionPos, e.getValue(), null));
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(Level world, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setLevel(world);
        BlockPos checkPos = start.m_121955_((Vec3i)new BlockPos(x, y, z).m_7954_(rotation));
        BlockState state = world.m_8055_(checkPos).m_60717_(AbstractMultiblock.fixHorizontal(rotation));
        StateMatcher matcher = this.stateMatchers.getOrDefault(new BlockPos(x, y, z), Matchers.ANY);
        return matcher.getStatePredicate().test((BlockGetter)world, checkPos, state);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.symmetrical);
        buffer.m_130130_(this.offX);
        buffer.m_130130_(this.offY);
        buffer.m_130130_(this.offZ);
        buffer.m_130130_(this.viewOffX);
        buffer.m_130130_(this.viewOffY);
        buffer.m_130130_(this.viewOffZ);
        buffer.m_130130_(this.stateMatchers.size());
        for (Map.Entry<BlockPos, StateMatcher> entry : this.stateMatchers.entrySet()) {
            buffer.m_130064_(entry.getKey());
            buffer.m_130085_(entry.getValue().getType());
            entry.getValue().toNetwork(buffer);
        }
    }

    public BlockState m_8055_(BlockPos pos) {
        long ticks = this.level != null ? this.level.m_46467_() : 0L;
        return this.stateMatchers.getOrDefault(pos, Matchers.AIR).getDisplayedState(ticks);
    }
}

