/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.multiblock.matcher;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.api.multiblock.StateMatcher;
import ru.blatfan.blatapi.api.multiblock.TriPredicate;

public class DisplayOnlyMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = BlatApi.loc("display");
    private final BlockState displayState;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected DisplayOnlyMatcher(BlockState displayState) {
        this.displayState = displayState;
        this.predicate = (blockGetter, blockPos, blockState) -> true;
    }

    public static DisplayOnlyMatcher fromJson(JsonObject json) {
        try {
            BlockState displayState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"display")), (boolean)false).f_234748_();
            return new DisplayOnlyMatcher(displayState);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for DisplayOnlyMatcher.", e);
        }
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        return this.displayState;
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.displayState));
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayOnlyMatcher that = (DisplayOnlyMatcher)o;
        return this.displayState.equals(that.displayState);
    }
}

