/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.player_stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ru.blatfan.blatapi.common.player_stages.PlayerStageEvent;
import ru.blatfan.blatapi.common.player_stages.PlayerStagesProvider;
import ru.blatfan.blatapi.common.player_stages.PlayerStagesSync;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;
import ru.blatfan.blatapi.utils.ICapacity;

public class PlayerStages
implements ICapacity<PlayerStages> {
    public static final List<String> allStages = new ArrayList<String>();
    private final Map<String, Boolean> data = new HashMap<String, Boolean>();

    private static boolean sendEvent(Player player, String key, boolean value) {
        PlayerStageEvent event = new PlayerStageEvent(player, key, value);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isValue();
    }

    @Override
    public void sync(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FluffyFurPacketHandler.sendTo(player, (Object)new PlayerStagesSync(this));
        }
    }

    public Map<String, Boolean> getAll() {
        return Collections.unmodifiableMap(this.data);
    }

    public static PlayerStages get(Player player) {
        return (PlayerStages)player.getCapability(PlayerStagesProvider.CAPABILITY, null).orElse((Object)new PlayerStages());
    }

    public static boolean get(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        return stages.data.getOrDefault(key, false);
    }

    public static void add(Player player, String key) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.data.put(key, PlayerStages.sendEvent(player, key, true));
            playerStages.sync((Entity)player);
        });
    }

    public static void set(Player player, String key, boolean b) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.data.put(key, PlayerStages.sendEvent(player, key, b));
            playerStages.sync((Entity)player);
        });
    }

    public static void remove(Player player, String key) {
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.data.put(key, PlayerStages.sendEvent(player, key, false));
            playerStages.sync((Entity)player);
        });
    }

    @Override
    public Tag toNBT() {
        CompoundTag nbt = new CompoundTag();
        for (String key : this.data.keySet()) {
            nbt.m_128379_(key, this.data.get(key).booleanValue());
        }
        return nbt;
    }

    @Override
    public void fromNBT(Tag tag) {
        this.data.clear();
        CompoundTag nbt = (CompoundTag)tag;
        for (String key : nbt.m_128431_()) {
            this.data.put(key, nbt.m_128471_(key));
        }
    }

    @Override
    public void copy(PlayerStages instance) {
        this.data.clear();
        for (String key : instance.data.keySet()) {
            this.data.put(key, instance.data.get(key));
        }
    }

    @Override
    public PlayerStages clone() {
        PlayerStages instance = new PlayerStages();
        for (String key : this.data.keySet()) {
            instance.data.put(key, this.data.get(key));
        }
        return instance;
    }
}

