/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import ru.blatfan.blatapi.utils.ItemHelper;

public class IngredientWithCount
implements Predicate<ItemStack> {
    public final Ingredient ingredient;
    public final int count;

    public IngredientWithCount(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.getItem(), this.getCount(), this.ingredient.m_43908_()[0].m_41783_());
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.ingredient.m_43908_()) {
            stacks.add(ItemHelper.withSize(stack, this.getCount(), false));
        }
        return stacks;
    }

    public Item getItem() {
        return this.ingredient.m_43908_()[0].m_41720_();
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return this.ingredient.test(stack) && stack.m_41613_() >= this.getCount();
    }

    public static IngredientWithCount read(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        byte count = buffer.readByte();
        return new IngredientWithCount(ingredient, count);
    }

    public void write(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeByte(this.count);
    }

    public static IngredientWithCount deserialize(JsonObject object) {
        Ingredient input = object.has("ingredient_list") ? Ingredient.m_43917_((JsonElement)object.get("ingredient_list")) : Ingredient.m_43917_((JsonElement)object);
        int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return new IngredientWithCount(input, count);
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        JsonElement serialize = this.ingredient.m_43942_();
        if (serialize.isJsonObject()) {
            object = serialize.getAsJsonObject();
        } else {
            object.add("ingredient_list", this.ingredient.m_43942_());
        }
        object.addProperty("count", (Number)this.count);
        return object;
    }

    public int getCount() {
        return this.count;
    }
}

