/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.reward;

import com.google.gson.JsonObject;
import java.io.Serializable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.reward.Reward;

public class AttributeReward
extends Reward {
    private final boolean visible;
    private final ResourceLocation attributeLoc;
    private final float value;
    private final AttributeModifier.Operation operation;

    @Override
    public void apply(Player player) {
        Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(this.attributeLoc);
        if (attribute == null) {
            BlatApi.LOGGER.warn("Unknow attribute {}", (Object)this.attributeLoc);
            return;
        }
        if (player.m_21204_().m_22171_(attribute)) {
            player.m_21051_(attribute).m_22125_(new AttributeModifier("Skill", (double)this.value, this.operation));
        }
    }

    public static AttributeReward fromJson(JsonObject json) {
        ResourceLocation lc = ResourceLocation.m_135820_((String)json.get("attribute").getAsString());
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        float v = json.get("value").getAsFloat();
        AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)json.get("operation").getAsString().toUpperCase());
        return new AttributeReward(b, lc, v, op);
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("attribute", this.attributeLoc.toString());
        tag.m_128379_("visible", this.visible);
        tag.m_128350_("value", this.value);
        tag.m_128359_("op", this.operation.name());
        return tag;
    }

    public static Reward fromTag(CompoundTag tag) {
        return new AttributeReward(tag.m_128471_("visible"), ResourceLocation.m_135820_((String)tag.m_128461_("attribute")), tag.m_128457_("value"), AttributeModifier.Operation.valueOf((String)tag.m_128461_("op")));
    }

    @Override
    public Component text(Player player) {
        return Component.m_237115_((String)((Attribute)BuiltInRegistries.f_256951_.m_7745_(this.getAttributeLoc())).m_22087_()).m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)((this.getValue() > 0.0f ? "+" : "") + (Serializable)(this.getOperation() == AttributeModifier.Operation.ADDITION ? Float.valueOf(this.getValue()) : this.getValue() * 100.0f + "%"))).m_130940_(this.getValue() > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    public AttributeReward(boolean visible, ResourceLocation attributeLoc, float value, AttributeModifier.Operation operation) {
        this.visible = visible;
        this.attributeLoc = attributeLoc;
        this.value = value;
        this.operation = operation;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public ResourceLocation getAttributeLoc() {
        return this.attributeLoc;
    }

    public float getValue() {
        return this.value;
    }

    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }
}

