/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.task;

import com.google.gson.JsonObject;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import ru.blatfan.blatapi.common.player_stages.PlayerStages;
import ru.blatfan.blatapi.common.task.Task;
import ru.blatfan.blatapi.utils.Text;

public class EatTask
extends Task {
    private boolean visible;
    private ItemStack food;

    public static String getStage(ItemLike item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
        return "player_eat_" + id.m_135827_() + "_" + id.m_135815_();
    }

    @Override
    public boolean get(Player player) {
        return PlayerStages.get(player, EatTask.getStage((ItemLike)this.food.m_41720_()));
    }

    public static EatTask fromJson(JsonObject json) {
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        ItemStack item = CraftingHelper.getItemStack((JsonObject)json.get("food").getAsJsonObject(), (boolean)true);
        PlayerStages.allStages.add(EatTask.getStage((ItemLike)item.m_41720_()));
        return new EatTask(b, item);
    }

    @Override
    public Component text(Player player) {
        return Text.create("task.blatapi.eat").add(this.food.m_41611_()).withColor(Color.WHITE);
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mX, int mY, Player player) {
        gui.m_280480_(this.food, x, y);
        gui.m_280370_(Minecraft.m_91087_().f_91062_, this.food, x, y);
        super.render(gui, x + 24, y, mX, mY, player);
    }

    public EatTask(boolean visible, ItemStack food) {
        this.visible = visible;
        this.food = food;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public ItemStack getFood() {
        return this.food;
    }
}

