/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.task;

import com.google.gson.JsonObject;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import ru.blatfan.blatapi.common.task.Task;
import ru.blatfan.blatapi.utils.Text;

public class ItemTask
extends Task {
    private boolean visible;
    private int amount;
    private ItemStack item;

    @Override
    public boolean get(Player player) {
        int pamount = 0;
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (!itemStack.m_150930_(this.item.m_41720_())) continue;
            pamount += itemStack.m_41613_();
        }
        return pamount >= this.amount;
    }

    public static ItemTask fromJson(JsonObject json) {
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        int a = !json.has("amount") ? 1 : json.get("amount").getAsInt();
        ItemStack item = CraftingHelper.getItemStack((JsonObject)json.get("item").getAsJsonObject(), (boolean)true);
        return new ItemTask(b, a, item);
    }

    @Override
    public Component text(Player player) {
        return Text.create(this.item.m_41611_()).add(" x" + this.amount).withColor(Color.WHITE);
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mX, int mY, Player player) {
        gui.m_280480_(this.item, x, y);
        gui.m_280370_(Minecraft.m_91087_().f_91062_, this.item, x, y);
        super.render(gui, x + 24, y, mX, mY, player);
    }

    public ItemTask(boolean visible, int amount, ItemStack item) {
        this.visible = visible;
        this.amount = amount;
        this.item = item;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemStack getItem() {
        return this.item;
    }
}

