/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.task;

import com.google.gson.JsonObject;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.player_stages.PlayerStages;
import ru.blatfan.blatapi.common.task.Task;
import ru.blatfan.blatapi.utils.ClientTicks;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.Text;

public class KillTask
extends Task {
    private boolean visible;
    private ResourceLocation entity;

    public static String getStage(ResourceLocation entity) {
        return "player_kill_" + entity.m_135827_() + "_" + entity.m_135815_();
    }

    public static String getStage(EntityType<?> type) {
        ResourceLocation entity = BuiltInRegistries.f_256780_.m_7981_(type);
        return "player_kill_" + entity.m_135827_() + "_" + entity.m_135815_();
    }

    @Override
    public boolean get(Player player) {
        return PlayerStages.get(player, KillTask.getStage(this.entity));
    }

    public EntityType<?> getEntity() {
        return (EntityType)BuiltInRegistries.f_256780_.m_7745_(this.entity);
    }

    public static KillTask fromJson(JsonObject json) {
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        ResourceLocation entity = ResourceLocation.m_135820_((String)json.get("entity").getAsString());
        PlayerStages.allStages.add(KillTask.getStage(entity));
        return new KillTask(b, entity);
    }

    @Override
    public Component text(Player player) {
        return Text.create("task.blatapi.kill").add(this.getEntity().m_20676_()).withColor(Color.WHITE);
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mX, int mY, Player player) {
        super.render(gui, x + 16, y, mX, mY, player);
        Entity e = ((EntityType)BuiltInRegistries.f_256780_.m_7745_(this.entity)).m_20615_((Level)GuideClient.level);
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)e;
        living.f_20885_ = 0.0f;
        living.f_20886_ = 0.0f;
        gui.m_280588_(x, y, x + 16, y + 16);
        GuiUtil.renderEntityQuaternionf(gui, x + 8, y + 16, 8, Axis.f_252436_.m_252977_((float)ClientTicks.ticks), Axis.f_252529_.m_252977_(180.0f), living);
        gui.m_280618_();
    }

    public KillTask(boolean visible, ResourceLocation entity) {
        this.visible = visible;
        this.entity = entity;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

