/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.task;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.task.AdvancementTask;
import ru.blatfan.blatapi.common.task.BookEntryTask;
import ru.blatfan.blatapi.common.task.CraftTask;
import ru.blatfan.blatapi.common.task.EatTask;
import ru.blatfan.blatapi.common.task.EmptyTask;
import ru.blatfan.blatapi.common.task.ItemTask;
import ru.blatfan.blatapi.common.task.KillTask;
import ru.blatfan.blatapi.common.task.NotTask;
import ru.blatfan.blatapi.common.task.PositionTask;
import ru.blatfan.blatapi.common.task.StageTask;
import ru.blatfan.blatapi.common.task.ViewBookEntryTask;
import ru.blatfan.blatapi.utils.Text;

public abstract class Task {
    public static final Map<ResourceLocation, Function<JsonObject, Task>> types = new HashMap<ResourceLocation, Function<JsonObject, Task>>();

    public abstract boolean get(Player var1);

    public abstract boolean isVisible();

    public static Task fromJson(JsonObject json) {
        ResourceLocation type = ResourceLocation.m_135820_((String)json.get("type").getAsString());
        return types.containsKey(type) ? types.get(type).apply(json) : new EmptyTask();
    }

    public abstract Component text(Player var1);

    public void render(GuiGraphics gui, int x, int y, int mX, int mY, Player player) {
        Text text = Text.create(this.text(player)).withColor(this.get(player) ? Color.GREEN : Color.RED);
        gui.m_280430_(Minecraft.m_91087_().f_91062_, (Component)text, x, y + 4, text.getColor().getRGB());
    }

    static {
        types.put(BlatApi.loc("item"), ItemTask::fromJson);
        types.put(BlatApi.loc("position"), PositionTask::fromJson);
        types.put(BlatApi.loc("stage"), StageTask::fromJson);
        types.put(BlatApi.loc("book_entry"), BookEntryTask::fromJson);
        types.put(BlatApi.loc("view_book_entry"), ViewBookEntryTask::fromJson);
        types.put(BlatApi.loc("advancement"), AdvancementTask::fromJson);
        types.put(BlatApi.loc("not"), NotTask::fromJson);
        types.put(BlatApi.loc("craft"), CraftTask::fromJson);
        types.put(BlatApi.loc("kill"), KillTask::fromJson);
        types.put(BlatApi.loc("eat"), EatTask::fromJson);
    }
}

