/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.task;

import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.common.GuideManager;
import ru.blatfan.blatapi.common.task.Task;

public class ViewBookEntryTask
extends Task {
    private final boolean visible;
    private final ResourceLocation entry;

    @Override
    public boolean get(Player player) {
        if (this.getEntry() == null) {
            return false;
        }
        if (GuideManager.getEntry(this.getEntry()) == null) {
            return false;
        }
        return GuideManager.getEntry(this.getEntry()).visible(player);
    }

    public static ViewBookEntryTask fromJson(JsonObject json) {
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        String stage = json.get("book_entry").getAsString();
        return new ViewBookEntryTask(b, new ResourceLocation(stage));
    }

    @Override
    public Component text(Player player) {
        return Component.m_237110_((String)"task.blatapi.book_entry", (Object[])new Object[]{this.getEntry()});
    }

    public ViewBookEntryTask(boolean visible, ResourceLocation entry) {
        this.visible = visible;
        this.entry = entry;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public ResourceLocation getEntry() {
        return this.entry;
    }
}

