/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.BARegistry;
import ru.blatfan.blatapi.common.recipe.IAnvilRepairRecipe;
import ru.blatfan.blatapi.compat.jei.category.AnvilRecipeCategory;
import ru.blatfan.blatapi.mixins.common.AccessorJEIRecipeManager;
import ru.blatfan.blatapi.utils.DisabledRecipes;
import ru.blatfan.blatapi.utils.RecipeHelper;

@JeiPlugin
public final class JeiIntegration
implements IModPlugin {
    public static final ResourceLocation UID = BlatApi.loc("jei_plugin");
    public static IJeiRuntime jeiRuntime;

    public static void showRecipe(ItemStack stack) {
        IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
        jeiRuntime.getRecipesGui().show(focus);
    }

    public static void showUses(ItemStack stack) {
        IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
        jeiRuntime.getRecipesGui().show(focus);
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiIntegration.jeiRuntime = jeiRuntime;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)BARegistry.GUIDE_BOOK.get()), (stack, context) -> {
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("guide_book_id")) {
                return "";
            }
            return stack.m_41783_().m_128461_("guide_book_id");
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AnvilRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AnvilRecipeCategory.RECIPE_TYPE, RecipeHelper.getRecipeManager().m_44013_((net.minecraft.world.item.crafting.RecipeType)BARegistry.ANVIL.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50322_), new RecipeType[]{AnvilRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50323_), new RecipeType[]{AnvilRecipeCategory.RECIPE_TYPE, RecipeTypes.ANVIL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50324_), new RecipeType[]{AnvilRecipeCategory.RECIPE_TYPE, RecipeTypes.ANVIL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AnvilMenu.class, MenuType.f_39964_, AnvilRecipeCategory.RECIPE_TYPE, 0, 2, 3, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AnvilScreen.class, 102, 48, 22, 15, new RecipeType[]{AnvilRecipeCategory.RECIPE_TYPE, RecipeTypes.ANVIL});
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        ArrayList recipesToAdd = new ArrayList();
        ArrayList ingredientsToAdd = new ArrayList();
        ((AccessorJEIRecipeManager)registration.getRecipeManager()).anvilapi$getInternal().getRecipesStream(RecipeTypes.ANVIL, registration.getJeiHelpers().getFocusFactory().getEmptyFocusGroup(), false).forEach(recipe -> {
            if (recipe.getRightInputs().stream().anyMatch(rightInput -> DisabledRecipes.isRepairItemDisabled(rightInput) || recipe.getLeftInputs().stream().anyMatch(leftInput -> DisabledRecipes.isRepairDisabled(leftInput, rightInput) || rightInput.m_41720_() instanceof EnchantedBookItem && EnchantmentHelper.m_44831_((ItemStack)rightInput).entrySet().stream().anyMatch(entry -> DisabledRecipes.isEnchantmentDisabled(leftInput, (Enchantment)entry.getKey(), (Integer)entry.getValue()))))) {
                registration.getRecipeManager().hideRecipes(RecipeTypes.ANVIL, Collections.singletonList(recipe));
                ArrayList<ItemStack> leftInputs = new ArrayList<ItemStack>(recipe.getLeftInputs());
                ArrayList<ItemStack> rightInputs = new ArrayList<ItemStack>(recipe.getRightInputs());
                ingredientsToAdd.addAll(leftInputs.stream().filter(stack -> registration.getIngredientVisibility().isIngredientVisible((IIngredientType)VanillaTypes.ITEM_STACK, stack)).map(stack -> new ItemStack((ItemLike)stack.m_41720_())).toList());
                ingredientsToAdd.addAll(rightInputs.stream().filter(stack -> registration.getIngredientVisibility().isIngredientVisible((IIngredientType)VanillaTypes.ITEM_STACK, stack)).map(stack -> new ItemStack((ItemLike)stack.m_41720_())).toList());
                ArrayList outputs = new ArrayList(recipe.getOutputs());
                if (leftInputs.stream().allMatch(input -> input.m_150930_(((ItemStack)leftInputs.get(0)).m_41720_()))) {
                    ItemStack leftInput2 = (ItemStack)leftInputs.get(0);
                    if (rightInputs.stream().anyMatch(input -> !(input.m_41720_() instanceof EnchantedBookItem))) {
                        rightInputs.removeIf(DisabledRecipes::isRepairItemDisabled);
                        if (DisabledRecipes.isRepairDisabled(leftInput2, null)) {
                            return;
                        }
                        rightInputs.removeIf(input -> DisabledRecipes.isRepairDisabled(leftInput2, input));
                    } else {
                        int done = 0;
                        int index = 0;
                        while (index - done < rightInputs.size()) {
                            if (EnchantmentHelper.m_44831_((ItemStack)((ItemStack)rightInputs.get(index - done))).entrySet().stream().anyMatch(enchantment -> DisabledRecipes.isEnchantmentDisabled(leftInput2, (Enchantment)enchantment.getKey(), (Integer)enchantment.getValue()))) {
                                if (rightInputs.size() == outputs.size()) {
                                    outputs.remove(index - done);
                                }
                                rightInputs.remove(index - done);
                                ++done;
                            }
                            ++index;
                        }
                    }
                    if (!rightInputs.isEmpty()) {
                        recipesToAdd.add(new AnvilRecipe(leftInputs, rightInputs, outputs, recipe.getUid()));
                    }
                } else {
                    ArrayList recipes = new ArrayList();
                    if (rightInputs.stream().anyMatch(input -> !(input.m_41720_() instanceof EnchantedBookItem))) {
                        leftInputs.removeIf(input -> DisabledRecipes.isRepairDisabled(input, null));
                        leftInputs.removeIf(leftInput -> {
                            boolean filter = false;
                            ArrayList newRightInputs = new ArrayList(rightInputs);
                            for (ItemStack rightInput : rightInputs) {
                                if (!DisabledRecipes.isRepairDisabled(leftInput, rightInput)) continue;
                                newRightInputs.remove(rightInput);
                                filter = true;
                            }
                            if (!filter) {
                                return false;
                            }
                            recipes.add(new AnvilRecipe(Collections.singletonList(leftInput), newRightInputs, (List)outputs, recipe.getUid()));
                            return true;
                        });
                    } else {
                        leftInputs.removeIf(leftInput -> {
                            ArrayList newRightInputs = new ArrayList(rightInputs);
                            ArrayList newOutputs = new ArrayList(outputs);
                            boolean filter = false;
                            int done = 0;
                            int index = 0;
                            while (index - done < newRightInputs.size()) {
                                if (EnchantmentHelper.m_44831_((ItemStack)((ItemStack)newRightInputs.get(index - done))).entrySet().stream().anyMatch(enchantment -> DisabledRecipes.isEnchantmentDisabled(leftInput, (Enchantment)enchantment.getKey(), (Integer)enchantment.getValue()))) {
                                    if (newRightInputs.size() == newOutputs.size()) {
                                        newOutputs.remove(index - done);
                                    }
                                    newRightInputs.remove(index - done);
                                    ++done;
                                    filter = true;
                                }
                                ++index;
                            }
                            if (!filter) {
                                return false;
                            }
                            recipes.add(new AnvilRecipe(Collections.singletonList(leftInput), newRightInputs, newOutputs, recipe.getUid()));
                            return true;
                        });
                    }
                    if (!recipes.isEmpty()) {
                        for (IJeiAnvilRecipe recipe1 : recipes) {
                            recipesToAdd.add(new AnvilRecipe(recipe1.getLeftInputs(), recipe1.getRightInputs(), recipe1.getOutputs(), recipe1.getUid()));
                        }
                    }
                    if (!leftInputs.isEmpty()) {
                        recipesToAdd.add(new AnvilRecipe(leftInputs, rightInputs, outputs, recipe.getUid()));
                    }
                }
            }
        });
        ArrayList recipes = new ArrayList();
        recipes.addAll(recipesToAdd);
        ArrayList<AnvilRecipe> rec = new ArrayList<AnvilRecipe>();
        for (IAnvilRepairRecipe recipe2 : RecipeHelper.getRecipes((net.minecraft.world.item.crafting.RecipeType)BARegistry.ANVIL_REPAIR.get())) {
            rec.add(new AnvilRecipe(Stream.of(recipe2.getBaseItem().m_7968_()).peek(input -> input.m_41721_(input.m_41776_())).toList(), Arrays.asList(recipe2.getRepairItem().m_43908_()), Stream.of(recipe2.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())).peek(input -> input.m_41721_(input.m_41776_() * 3 / 4)).toList(), recipe2.m_6423_()));
        }
        recipes.addAll(rec);
        if (!recipes.isEmpty()) {
            registration.getRecipeManager().addRecipes(RecipeTypes.ANVIL, recipes.stream().distinct().toList());
        }
        if (!ingredientsToAdd.isEmpty()) {
            registration.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, ingredientsToAdd);
        }
    }
}

