/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import ru.blatfan.blatapi.client.render.MultiblockPreviewRenderer;
import ru.blatfan.blatapi.fluffy_fur.client.event.FluffyFurClientEvents;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.FluffyFurMod;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.FluffyFurModsHandler;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.FluffyFurPanorama;
import ru.blatfan.blatapi.fluffy_fur.client.splash.SplashHandler;
import ru.blatfan.blatapi.fluffy_fur.integration.client.ShadersIntegration;
import ru.blatfan.blatapi.fluffy_fur.registry.common.item.FluffyFurCreativeTabs;
import ru.blatfan.blatapi.utils.ClientTicks;
import ru.blatfan.blatapi.utils.Text;

public class FluffyFurClient {
    public static boolean optifinePresent = false;
    public static boolean piracyPresent = false;
    public static FluffyFurMod MOD_INSTANCE;
    public static FluffyFurPanorama VANILLA_PANORAMA;

    public static void clientSetup(FMLClientSetupEvent event) {
        try {
            Class.forName("net.optifine.Config");
            optifinePresent = true;
        }
        catch (ClassNotFoundException e2) {
            optifinePresent = false;
        }
        piracyPresent = ModList.get().isLoaded("tlskincape");
        FluffyFurClient.setupMenu();
        FluffyFurClient.setupSplashes();
        ShadersIntegration.init();
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                ClientTicks.endClientTick(Minecraft.m_91087_());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ClientTicks.renderTickStart(e.renderTickTime);
            } else {
                ClientTicks.renderTickEnd();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                MultiblockPreviewRenderer.onClientTick();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                MultiblockPreviewRenderer.onRenderLevelLastEvent(e.getPoseStack());
            }
        });
    }

    public static void setupMenu() {
        MOD_INSTANCE = new FluffyFurMod("blatapi", "BlatApi", "0.3.0").setDev("BlatFan").setItem(new ItemStack((ItemLike)Items.f_151049_)).setNameColor(new Color(142, 95, 239)).setVersionColor(new Color(65, 36, 138)).setDescription((Component)Component.m_237115_((String)"mod_description.blatapi")).addGithubLink("https://github.com/BlatFan/BlatApi").addCurseForgeLink("https://www.curseforge.com/minecraft/mc-mods/blatapi").addModrinthLink("https://modrinth.com/mod/blatapi").addDiscordLink("https://discord.gg/eHJChH9mqH");
        VANILLA_PANORAMA = new FluffyFurPanorama("minecraft:vanilla", Text.create("panorama.minecraft.vanilla")).setItem(new ItemStack((ItemLike)Items.f_42276_));
        FluffyFurClient.registerMod(MOD_INSTANCE);
        FluffyFurClient.registerPanorama(VANILLA_PANORAMA);
    }

    public static void registerMod(FluffyFurMod mod) {
        FluffyFurModsHandler.registerMod(mod);
    }

    public static void registerPanorama(FluffyFurPanorama panorama) {
        FluffyFurModsHandler.registerPanorama(panorama);
    }

    public static void setupSplashes() {
        SplashHandler.addSplash("\u041f\u0440\u0438\u0432\u0435\u0442, \u0420\u043e\u0441\u0441\u0438\u044f!");
        SplashHandler.addSplash("BlatFan!");
    }

    public static class ClientOnly {
        public static void clientInit() {
            IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
            IEventBus forgeBus = MinecraftForge.EVENT_BUS;
            forgeBus.register((Object)new FluffyFurClientEvents());
            eventBus.addListener(FluffyFurCreativeTabs::addCreativeTabContent);
        }
    }
}

