/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.event;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.blatfan.blatapi.fluffy_fur.FluffyFur;
import ru.blatfan.blatapi.fluffy_fur.FluffyFurClient;
import ru.blatfan.blatapi.fluffy_fur.client.bow.BowHandler;
import ru.blatfan.blatapi.fluffy_fur.client.event.ClientTickHandler;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.FluffyFurModsHandler;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.FluffyFurPanorama;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.PlayerSkinMenuScreen;
import ru.blatfan.blatapi.fluffy_fur.client.playerskin.PlayerSkinHandler;
import ru.blatfan.blatapi.fluffy_fur.client.screenshake.ScreenshakeHandler;
import ru.blatfan.blatapi.fluffy_fur.client.shader.postprocess.PostProcessHandler;
import ru.blatfan.blatapi.fluffy_fur.config.FluffyFurClientConfig;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurKeyMappings;

public class FluffyFurClientEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onOpenScreen(ScreenEvent.Opening event) {
        FluffyFurClientEvents.panoramaScreen(event.getCurrentScreen());
        FluffyFurClientEvents.panoramaScreen(event.getNewScreen());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOpenScreenFirst(ScreenEvent.Opening event) {
        FluffyFurClientEvents.resetPanoramaScreen(event.getCurrentScreen());
        FluffyFurClientEvents.resetPanoramaScreen(event.getNewScreen());
    }

    public static void panoramaScreen(Screen screen) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            FluffyFurPanorama panorama = FluffyFurModsHandler.getPanorama((String)FluffyFurClientConfig.PANORAMA.get());
            if (panorama != null && !panorama.equals(FluffyFurClient.VANILLA_PANORAMA)) {
                boolean setPanorama;
                boolean bl = setPanorama = !TitleScreen.f_96716_.f_108846_[0].equals((Object)panorama.getTexture());
                if (setPanorama) {
                    FluffyFurModsHandler.setOpenPanorama(titleScreen, panorama);
                }
            }
        }
    }

    public static void resetPanoramaScreen(Screen screen) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            FluffyFurPanorama panorama = FluffyFurModsHandler.getPanorama((String)FluffyFurClientConfig.PANORAMA.get());
            if (panorama != null || panorama.equals(FluffyFurClient.VANILLA_PANORAMA)) {
                FluffyFurModsHandler.setOpenPanorama(titleScreen, FluffyFurClient.VANILLA_PANORAMA);
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerSkinHandler.skinTick(event.player);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientTickHandler.clientTick(event);
        if (event.phase == TickEvent.Phase.END) {
            if (minecraft.m_91104_()) {
                return;
            }
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            ScreenshakeHandler.clientTick(camera);
            PostProcessHandler.tick();
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        ClientTickHandler.renderTick(event);
    }

    @SubscribeEvent
    public void getFovModifier(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        ItemStack itemStack = player.m_21211_();
        if (player.m_6117_()) {
            for (Item item : BowHandler.getBows()) {
                int i;
                float f1;
                if (!itemStack.m_150930_(item)) continue;
                float f = event.getFovModifier();
                if (f != event.getNewFovModifier()) {
                    f = event.getNewFovModifier();
                }
                f1 = (f1 = (float)(i = player.m_21252_()) / 20.0f) > 1.0f ? 1.0f : (f1 *= f1);
                event.setNewFovModifier((float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)(f *= 1.0f - f1 * 0.15f)));
            }
        }
        ScreenshakeHandler.fovTick(event);
    }

    @SubscribeEvent
    public void onInput(InputEvent event) {
        String name;
        if (FluffyFurKeyMappings.SKIN_MENU.m_90857_() && ((name = FluffyFur.proxy.getPlayer().m_36316_().getName()).equals("Dev") || name.equals("BlatFan") || FluffyFur.proxy.getPlayer().m_20310_(4))) {
            Minecraft.m_91087_().m_91152_((Screen)new PlayerSkinMenuScreen());
        }
    }
}

