/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.playerskin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.fluffy_fur.client.model.playerskin.PlayerSkinData;
import ru.blatfan.blatapi.fluffy_fur.client.playerskin.PlayerSkin;
import ru.blatfan.blatapi.fluffy_fur.client.playerskin.PlayerSkinCape;
import ru.blatfan.blatapi.fluffy_fur.client.playerskin.PlayerSkinEffect;
import ru.blatfan.blatapi.fluffy_fur.common.capability.IPlayerSkin;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;
import ru.blatfan.blatapi.fluffy_fur.common.network.playerskin.PlayerSkinSetCapePacket;
import ru.blatfan.blatapi.fluffy_fur.common.network.playerskin.PlayerSkinSetEffectPacket;
import ru.blatfan.blatapi.fluffy_fur.common.network.playerskin.PlayerSkinSetPacket;

public class PlayerSkinHandler {
    public static Map<String, PlayerSkin> skins = new HashMap<String, PlayerSkin>();
    public static Map<String, PlayerSkinEffect> skinEffects = new HashMap<String, PlayerSkinEffect>();
    public static Map<String, PlayerSkinCape> skinCapes = new HashMap<String, PlayerSkinCape>();

    public static void register(PlayerSkin skin) {
        skins.put(skin.getId(), skin);
    }

    public static PlayerSkin getSkin(Player player) {
        AtomicReference id = new AtomicReference();
        player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> id.set(s.getSkin()));
        if (skins.containsKey(id.get())) {
            return skins.get(id.get());
        }
        return null;
    }

    public static List<PlayerSkin> getSkins() {
        return new ArrayList<PlayerSkin>(skins.values());
    }

    public static PlayerSkinData getSkinData(Player player) {
        AtomicReference data = new AtomicReference();
        player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> data.set(s.getSkinData()));
        return (PlayerSkinData)data.get();
    }

    public static void setSkinData(Player player, PlayerSkinData data) {
        player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkinData(data));
    }

    public static void skinTick(Player player) {
        PlayerSkinEffect skinEffect;
        PlayerSkin skin = PlayerSkinHandler.getSkin(player);
        if (skin != null) {
            skin.tick(player);
        }
        if ((skinEffect = PlayerSkinHandler.getSkinEffect(player)) != null) {
            skinEffect.tick(player);
        }
    }

    public static void setSkin(Player player, String skin) {
        if (skin != null) {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkin(skin));
            PlayerSkinHandler.setSkinData(player, new PlayerSkinData());
        } else {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkin(""));
        }
    }

    public static void setSkin(Player player, PlayerSkin skin) {
        if (skin != null) {
            PlayerSkinHandler.setSkin(player, skin.getId());
        } else {
            PlayerSkinHandler.setSkin(player, "");
        }
    }

    public static void setSkinPacket(PlayerSkin skin) {
        FluffyFurPacketHandler.sendToServer(new PlayerSkinSetPacket(skin.getId()));
    }

    public static void setSkinPacket(String skin) {
        FluffyFurPacketHandler.sendToServer(new PlayerSkinSetPacket(skin));
    }

    public static void register(PlayerSkinEffect effect) {
        skinEffects.put(effect.getId(), effect);
    }

    public static PlayerSkinEffect getSkinEffect(Player player) {
        AtomicReference id = new AtomicReference();
        player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> id.set(s.getSkinEffect()));
        if (skinEffects.containsKey(id.get())) {
            return skinEffects.get(id.get());
        }
        return null;
    }

    public static List<PlayerSkinEffect> getSkinEffects() {
        return new ArrayList<PlayerSkinEffect>(skinEffects.values());
    }

    public static void setSkinEffect(Player player, String effect) {
        if (effect != null) {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkinEffect(effect));
            PlayerSkinHandler.setSkinData(player, new PlayerSkinData());
        } else {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkinEffect(""));
        }
    }

    public static void setSkinEffect(Player player, PlayerSkinEffect effect) {
        if (effect != null) {
            PlayerSkinHandler.setSkinEffect(player, effect.getId());
        } else {
            PlayerSkinHandler.setSkinEffect(player, "");
        }
    }

    public static void setSkinEffectPacket(PlayerSkinEffect effect) {
        FluffyFurPacketHandler.sendToServer(new PlayerSkinSetEffectPacket(effect.getId()));
    }

    public static void setSkinEffectPacket(String effect) {
        FluffyFurPacketHandler.sendToServer(new PlayerSkinSetEffectPacket(effect));
    }

    public static PlayerSkinCape getSkinCape(Player player) {
        AtomicReference id = new AtomicReference();
        player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> id.set(s.getSkinCape()));
        if (skinCapes.containsKey(id.get())) {
            return skinCapes.get(id.get());
        }
        return null;
    }

    public static List<PlayerSkinCape> getSkinCapes() {
        return new ArrayList<PlayerSkinCape>(skinCapes.values());
    }

    public static void setSkinCape(Player player, String cape) {
        if (cape != null) {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkinCape(cape));
            PlayerSkinHandler.setSkinData(player, new PlayerSkinData());
        } else {
            player.getCapability(IPlayerSkin.INSTANCE, null).ifPresent(s -> s.setSkinCape(""));
        }
    }

    public static void setSkinCape(Player player, PlayerSkinCape cape) {
        if (cape != null) {
            PlayerSkinHandler.setSkinCape(player, cape.getId());
        } else {
            PlayerSkinHandler.setSkinCape(player, "");
        }
    }

    public static void setSkinCapePacket(PlayerSkinCape cape) {
        FluffyFurPacketHandler.sendToServer(new PlayerSkinSetCapePacket(cape.getId()));
    }

    public static void setSkinCapePacket(String cape) {
        FluffyFurPacketHandler.sendToServer(new PlayerSkinSetCapePacket(cape));
    }

    public static void register(PlayerSkinCape cape) {
        skinCapes.put(cape.getId(), cape);
    }
}

