/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.screenshake;

import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import ru.blatfan.blatapi.fluffy_fur.client.screenshake.ScreenshakeInstance;
import ru.blatfan.blatapi.fluffy_fur.common.easing.Easing;

public class PositionedScreenshakeInstance
extends ScreenshakeInstance {
    public final Vec3 position;
    public final float falloffDistance;
    public final float maxDistance;
    public final Easing falloffEasing;

    public PositionedScreenshakeInstance(int duration, Vec3 position, float falloffDistance, float maxDistance, Easing falloffEasing) {
        super(duration);
        this.position = position;
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
        this.falloffEasing = falloffEasing;
    }

    public PositionedScreenshakeInstance(int duration, Vec3 position, float falloffDistance, float maxDistance) {
        this(duration, position, falloffDistance, maxDistance, Easing.LINEAR);
    }

    @Override
    public float updateIntensity(Camera camera) {
        float intensity = super.updateIntensity(camera);
        float distance = (float)this.position.m_82554_(camera.m_90583_());
        if (distance > this.maxDistance) {
            return 0.0f;
        }
        float distanceMultiplier = 1.0f;
        if (distance > this.falloffDistance) {
            float remaining = this.maxDistance - this.falloffDistance;
            float current = distance - this.falloffDistance;
            distanceMultiplier = 1.0f - current / remaining;
        }
        Vector3f lookDirection = camera.m_253058_();
        Vec3 directionToScreenshake = this.position.m_82546_(camera.m_90583_()).m_82541_();
        float angle = Math.max(0.0f, lookDirection.dot((Vector3fc)new Vector3f((float)directionToScreenshake.f_82479_, (float)directionToScreenshake.f_82480_, (float)directionToScreenshake.f_82481_)));
        return (intensity + intensity * angle) * 0.5f * distanceMultiplier;
    }
}

