/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.blatfan.blatapi.fluffy_fur.common.capability.IPlayerSkin;
import ru.blatfan.blatapi.fluffy_fur.common.capability.PlayerSkinProvider;
import ru.blatfan.blatapi.fluffy_fur.common.network.BloodPacket;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;
import ru.blatfan.blatapi.fluffy_fur.common.network.playerskin.PlayerSkinUpdatePacket;

public class FluffyFurEvents {
    public List<Player> playerSkinUpdate = new ArrayList<Player>();

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("blatapi", "player_skin"), (ICapabilityProvider)new PlayerSkinProvider());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        Capability<IPlayerSkin> KNOWLEDGE = IPlayerSkin.INSTANCE;
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(KNOWLEDGE).ifPresent(k -> event.getOriginal().getCapability(KNOWLEDGE).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        if (!event.getEntity().m_9236_().f_46443_) {
            FluffyFurPacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new PlayerSkinUpdatePacket(event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!event.getLevel().m_5776_()) {
                FluffyFurPacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new PlayerSkinUpdatePacket(player));
                this.playerSkinUpdate.add(player);
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().m_5776_()) {
            for (Player player : this.playerSkinUpdate) {
                for (ServerPlayer serverPlayer : player.m_20194_().m_6846_().m_11314_()) {
                    FluffyFurPacketHandler.sendTo(serverPlayer, (Object)new PlayerSkinUpdatePacket(player));
                    if (player == serverPlayer) continue;
                    FluffyFurPacketHandler.sendTo(player, (Object)new PlayerSkinUpdatePacket((Player)serverPlayer));
                }
            }
            this.playerSkinUpdate.clear();
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            FluffyFurPacketHandler.sendToTracking(level, BlockPos.m_274446_((Position)pos), new BloodPacket(pos, event.getAmount()));
        }
    }
}

