/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.fire;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import ru.blatfan.blatapi.fluffy_fur.common.fire.FireBlockModifier;

public class FireBlockHandler {
    public static List<FireBlockModifier> modifiers = new ArrayList<FireBlockModifier>();

    public static void register(FireBlockModifier modifier) {
        modifiers.add(modifier);
    }

    public static List<FireBlockModifier> getModifiers() {
        return modifiers;
    }

    public static boolean canLightBlock(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        for (FireBlockModifier modifier : FireBlockHandler.getModifiers()) {
            if (!modifier.canLightBlock(level, blockPos, blockState, entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean canSetFireBlock(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        return BaseFireBlock.m_49255_((Level)level, (BlockPos)blockPos, (Direction)Direction.UP);
    }

    public static boolean canSetFireBlock(Level level, BlockPos blockPos, BlockState blockState, Direction direction, Entity entity) {
        return BaseFireBlock.m_49255_((Level)level, (BlockPos)blockPos, (Direction)direction);
    }

    public static void setFireBlock(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        BlockState blockState1 = FireBlockHandler.getFireBlockState(level, blockPos, blockState, entity);
        level.m_7731_(blockPos, blockState1, 11);
    }

    public static BlockState getFireBlockState(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        return BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockPos);
    }

    public static void setLightBlock(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        for (FireBlockModifier modifier : FireBlockHandler.getModifiers()) {
            if (!modifier.canLightBlock(level, blockPos, blockState, entity)) continue;
            modifier.setLightBlock(level, blockPos, blockState, entity);
            break;
        }
    }
}

