/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.blatfan.blatapi.fluffy_fur.FluffyFur;
import ru.blatfan.blatapi.fluffy_fur.client.particle.ParticleBuilder;
import ru.blatfan.blatapi.fluffy_fur.client.particle.behavior.SparkParticleBehavior;
import ru.blatfan.blatapi.fluffy_fur.client.particle.data.ColorParticleData;
import ru.blatfan.blatapi.fluffy_fur.client.particle.data.GenericParticleData;
import ru.blatfan.blatapi.fluffy_fur.common.easing.Easing;
import ru.blatfan.blatapi.fluffy_fur.common.network.ClientPacket;
import ru.blatfan.blatapi.fluffy_fur.common.network.PositionClientPacket;
import ru.blatfan.blatapi.fluffy_fur.config.FluffyFurClientConfig;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurParticles;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurRenderTypes;

public class BloodPacket
extends PositionClientPacket {
    protected final double size;

    public BloodPacket(double x, double y, double z, double size) {
        super(x, y, z);
        this.size = size;
    }

    public BloodPacket(Vec3 vec, double size) {
        super(vec);
        this.size = size;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        if (((Boolean)FluffyFurClientConfig.BLOOD_PARTICLE.get()).booleanValue()) {
            Level level = FluffyFur.proxy.getLevel();
            double size = this.size;
            if (size > 100.0) {
                size = 100.0;
            }
            ParticleBuilder builder = ParticleBuilder.create(FluffyFurParticles.TINY_WISP);
            builder.setBehavior(SparkParticleBehavior.create().build()).setColorData(ColorParticleData.create(1.0f, 0.0f, 0.0f).build()).setTransparencyData(GenericParticleData.create(0.6f, 0.6f, 0.0f).setEasing(Easing.QUARTIC_OUT).build()).setScaleData(GenericParticleData.create(0.05f, 0.1f, 0.0f).setEasing(Easing.ELASTIC_OUT).build()).setLifetime(20).randomVelocity(0.5).addVelocity(0.0, 0.1f, 0.0).randomOffset(0.05f).setFriction(0.9f).enablePhysics().setGravity(1.0f).repeat(level, this.x, this.y, this.z, (int)size / 2, 0.4f);
            builder.setRenderType(FluffyFurRenderTypes.TRANSLUCENT_PARTICLE).repeat(level, this.x, this.y, this.z, (int)size, 0.6f);
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, BloodPacket.class, BloodPacket::encode, BloodPacket::decode, ClientPacket::handle);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.size);
    }

    public static BloodPacket decode(FriendlyByteBuf buf) {
        return new BloodPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

