/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.blatfan.blatapi.common.reward.ClientReward;
import ru.blatfan.blatapi.common.reward.Reward;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;

public class RewardPacket {
    private final List<Reward> rewards;

    public RewardPacket(List<Reward> rewards) {
        this.rewards = rewards;
    }

    public RewardPacket(FriendlyByteBuf buf) {
        this.rewards = new ArrayList<Reward>();
        for (int i = 0; i < buf.readInt(); ++i) {
            this.rewards.add(Reward.fromTag(buf.m_130260_()));
        }
    }

    public static void buffer(RewardPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.rewards.size());
        for (Reward r : message.rewards) {
            buffer.m_130079_(r.toTag());
        }
    }

    public static void register(SimpleChannel channel, int id) {
        channel.registerMessage(id, RewardPacket.class, RewardPacket::buffer, RewardPacket::new, RewardPacket::handler);
    }

    private static void handler(RewardPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        ServerPlayer player = FluffyFurPacketHandler.getPlayer(context);
        context.enqueueWork(() -> {
            for (Reward reward : packet.rewards) {
                if (reward instanceof ClientReward) continue;
                reward.apply((Player)player);
            }
        });
        context.setPacketHandled(true);
    }
}

