/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.network.playerskin;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;
import ru.blatfan.blatapi.fluffy_fur.common.network.ServerPacket;
import ru.blatfan.blatapi.fluffy_fur.common.network.playerskin.PlayerSkinChangeEffectPacket;

public class PlayerSkinChangePacket
extends ServerPacket {
    protected final double x;
    protected final double y;
    protected final double z;

    public PlayerSkinChangePacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PlayerSkinChangePacket(Vec3 vec) {
        this.x = vec.m_7096_();
        this.y = vec.m_7098_();
        this.z = vec.m_7094_();
    }

    @Override
    public void execute(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        FluffyFurPacketHandler.sendToTracking(player.m_9236_(), BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z), new PlayerSkinChangeEffectPacket(this.x, this.y, this.z));
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, PlayerSkinChangePacket.class, PlayerSkinChangePacket::encode, PlayerSkinChangePacket::decode, ServerPacket::handle);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static PlayerSkinChangePacket decode(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new PlayerSkinChangePacket(x, y, z);
    }
}

