/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.raycast;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayCastContext {
    public Vec3 startPos;
    public Vec3 endPos;
    public Predicate<BlockPos> blockPosFilter = b -> true;
    public Predicate<FluidState> fluidFilter = Fluid.NONE;
    public Predicate<Entity> entityFilter = e -> false;
    public int entityCount = 0;
    public float entitySize = 0.0f;
    public boolean entityEnd = false;
    public Block blockShape = Block.COLLIDER;
    public CollisionContext collisionContext = CollisionContext.m_82749_();

    public RayCastContext() {
        this.startPos = Vec3.f_82478_;
        this.endPos = Vec3.f_82478_;
    }

    public RayCastContext(Vec3 startPos, Vec3 endPos) {
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public RayCastContext setStartPos(Vec3 startPos) {
        this.startPos = startPos;
        return this;
    }

    public RayCastContext setEndPos(Vec3 endPos) {
        this.endPos = endPos;
        return this;
    }

    public RayCastContext setBlockPosFilter(Predicate<BlockPos> blockPosFilter) {
        this.blockPosFilter = blockPosFilter;
        return this;
    }

    public RayCastContext setFluidFilter(Predicate<FluidState> fluidFilter) {
        this.fluidFilter = fluidFilter;
        return this;
    }

    public RayCastContext setEntityFilter(Predicate<Entity> entityFilter) {
        this.entityFilter = entityFilter;
        return this;
    }

    public RayCastContext setEntityCount(int entityCount) {
        this.entityCount = entityCount;
        return this;
    }

    public RayCastContext setEntitySize(float entitySize) {
        this.entitySize = entitySize;
        return this;
    }

    public RayCastContext setEntityEnd(boolean entityEnd) {
        this.entityEnd = entityEnd;
        return this;
    }

    public RayCastContext setBlockShape(Block blockShape) {
        this.blockShape = blockShape;
        return this;
    }

    public RayCastContext setCollisionContext(CollisionContext collisionContext) {
        this.collisionContext = collisionContext;
        return this;
    }

    public Vec3 getStartPos() {
        return this.startPos;
    }

    public Vec3 getEndPos() {
        return this.endPos;
    }

    public Predicate<BlockPos> getBlockPosFilter() {
        return this.blockPosFilter;
    }

    public Predicate<FluidState> getFluidFilter() {
        return this.fluidFilter;
    }

    public Predicate<Entity> getEntityFilter() {
        return this.entityFilter;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public float getEntitySize() {
        return this.entitySize;
    }

    public boolean getEntityEnd() {
        return this.entityEnd;
    }

    public Block getBlockShape() {
        return this.blockShape;
    }

    public CollisionContext getCollisionContext() {
        return this.collisionContext;
    }

    public VoxelShape getBlockShape(BlockState blockState, BlockGetter level, BlockPos pos) {
        return this.blockShape.get(blockState, level, pos, this.collisionContext);
    }

    public VoxelShape getFluidShape(FluidState state, BlockGetter level, BlockPos pos) {
        return this.fluidFilter.test(state) ? state.m_76183_(level, pos) : Shapes.m_83040_();
    }

    public static class Fluid {
        public static Predicate<FluidState> NONE = f -> false;
        public static Predicate<FluidState> SOURCE_ONLY = FluidState::m_76170_;
        public static Predicate<FluidState> ANY = f -> !f.m_76178_();
        public static Predicate<FluidState> WATER = f -> f.m_205070_(FluidTags.f_13131_);
    }

    public static class Block
    implements ShapeGetter {
        public static Block COLLIDER = new Block(BlockBehaviour.BlockStateBase::m_60742_);
        public static Block OUTLINE = new Block(BlockBehaviour.BlockStateBase::m_60651_);
        public static Block VISUAL = new Block(BlockBehaviour.BlockStateBase::m_60771_);
        public final ShapeGetter shapeGetter;

        public Block(ShapeGetter shapeGetter) {
            this.shapeGetter = shapeGetter;
        }

        @Override
        public VoxelShape get(BlockState state, BlockGetter block, BlockPos pos, CollisionContext collisionContext) {
            return this.shapeGetter.get(state, block, pos, collisionContext);
        }
    }

    public static interface ShapeGetter {
        public VoxelShape get(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);
    }
}

