/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class BaseItemStackHandler
extends ItemStackHandler {
    private final Runnable onContentsChanged;
    private final Map<Integer, Integer> slotSizeMap;
    private BiFunction<Integer, ItemStack, Boolean> canInsert = null;
    private Function<Integer, Boolean> canExtract = null;
    private int maxStackSize = 64;
    private int[] outputSlots = null;

    protected BaseItemStackHandler(int size, Runnable onContentsChanged) {
        super(size);
        this.onContentsChanged = onContentsChanged;
        this.slotSizeMap = new HashMap<Integer, Integer>();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insertItem(slot, stack, simulate, false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, boolean container) {
        if (!container && this.outputSlots != null && ArrayUtils.contains((int[])this.outputSlots, (int)slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, false);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean container) {
        if (!container) {
            if (this.canExtract != null && !this.canExtract.apply(slot).booleanValue()) {
                return ItemStack.f_41583_;
            }
            if (this.outputSlots != null && !ArrayUtils.contains((int[])this.outputSlots, (int)slot)) {
                return ItemStack.f_41583_;
            }
        }
        return super.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.slotSizeMap.containsKey(slot) ? this.slotSizeMap.get(slot) : this.maxStackSize;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canInsert == null || this.canInsert.apply(slot, stack) != false;
    }

    protected void onContentsChanged(int slot) {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    public CompoundTag serializeNBT() {
        ListTag items = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag item = new CompoundTag();
            item.m_128405_("Slot", i);
            if (stack.m_41613_() > 64) {
                item.m_128405_("ExtendedCount", stack.m_41613_());
            }
            stack.m_41739_(item);
            items.add((Object)item);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)items);
        nbt.m_128405_("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag items = nbt.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.m_128728_(i);
            int slot = item.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)item);
            if (item.m_128441_("ExtendedCount")) {
                stack.m_41764_(item.m_128451_("ExtendedCount"));
            }
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public void setDefaultSlotLimit(int size) {
        this.maxStackSize = size;
    }

    public void addSlotLimit(int slot, int size) {
        if (size > 64 && size % 64 != 0) {
            throw new IllegalArgumentException("Slot limits above 64 must be a multiple of 64");
        }
        this.slotSizeMap.put(slot, size);
    }

    public void setOutputSlots(int ... slots) {
        this.outputSlots = slots;
    }

    public Container toIInventory() {
        return new SimpleContainer((ItemStack[])this.stacks.toArray((Object[])new ItemStack[0]));
    }

    public BaseItemStackHandler copy() {
        BaseItemStackHandler newInventory = new BaseItemStackHandler(this.getSlots(), this.onContentsChanged);
        newInventory.setDefaultSlotLimit(this.maxStackSize);
        newInventory.setCanInsert(this.canInsert);
        newInventory.setCanExtract(this.canExtract);
        newInventory.setOutputSlots(this.outputSlots);
        this.slotSizeMap.forEach(newInventory::addSlotLimit);
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            newInventory.setStackInSlot(i, stack.m_41777_());
        }
        return newInventory;
    }

    public static BaseItemStackHandler create(int size) {
        return BaseItemStackHandler.create(size, (BaseItemStackHandler builder) -> {});
    }

    public static BaseItemStackHandler create(int size, Runnable onContentsChanged) {
        return BaseItemStackHandler.create(size, onContentsChanged, builder -> {});
    }

    public static BaseItemStackHandler create(int size, Consumer<BaseItemStackHandler> builder) {
        return BaseItemStackHandler.create(size, null, builder);
    }

    public static BaseItemStackHandler create(int size, Runnable onContentsChanged, Consumer<BaseItemStackHandler> builder) {
        BaseItemStackHandler handler = new BaseItemStackHandler(size, onContentsChanged);
        builder.accept(handler);
        return handler;
    }

    public void setCanInsert(BiFunction<Integer, ItemStack, Boolean> canInsert) {
        this.canInsert = canInsert;
    }

    public void setCanExtract(Function<Integer, Boolean> canExtract) {
        this.canExtract = canExtract;
    }
}

