/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import ru.blatfan.blatapi.fluffy_fur.client.event.ClientTickHandler;
import ru.blatfan.blatapi.fluffy_fur.client.render.RenderBuilder;
import ru.blatfan.blatapi.fluffy_fur.common.block.entity.BlockSimpleInventory;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurRenderTypes;
import ru.blatfan.blatapi.utils.BaseItemStackHandler;
import ru.blatfan.blatapi.utils.ParticleItem;

public class BlockRendererUtil {
    public static void dispatchTEToNearbyPlayers(BlockEntity tile) {
        ServerLevel world = (ServerLevel)tile.m_58904_();
        world.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false).forEach(player -> player.f_8906_.m_9829_(tile.m_58483_()));
    }

    public static void dispatchTEToNearbyPlayers(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            BlockRendererUtil.dispatchTEToNearbyPlayers(tile);
        }
    }

    public static void renderItem(BlockEntity block, double x, double y, double z, List<Float> size, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1, ItemStack itemStack) {
        BlockRendererUtil.renderItem(block.m_58899_(), x, y, z, size, poseStack, multiBufferSource, i, i1, itemStack);
    }

    private static double getItemY() {
        double tick = Minecraft.m_91087_().f_91073_ == null ? (double)System.currentTimeMillis() / 800.0 : (double)Minecraft.m_91087_().f_91073_.m_46467_() / 16.0;
        return Math.sin(tick % (Math.PI * 2)) * 0.065;
    }

    private static double getItemSpin() {
        double tick = Minecraft.m_91087_().f_91073_ == null ? (double)System.currentTimeMillis() / 800.0 : (double)Minecraft.m_91087_().f_91073_.m_46467_() / 16.0;
        return tick * 40.0 % 360.0;
    }

    public static void renderItem(BlockPos pos, double x, double y, double z, List<Float> size, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1, ItemStack itemStack) {
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        float scale = (itemStack.m_41720_() instanceof BlockItem ? size.get(0) : size.get(1)).floatValue();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(0.0, BlockRendererUtil.getItemY(), 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)BlockRendererUtil.getItemSpin()));
        Item item = itemStack.m_41720_();
        if (item instanceof ParticleItem) {
            ParticleItem item2 = (ParticleItem)item;
            item2.worldParticles((float)((double)pos.m_123341_() + x), (float)((double)pos.m_123342_() + y + BlockRendererUtil.getItemY()), (float)((double)pos.m_123343_() + z));
        }
        Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.GROUND, i, i1, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, itemStack.m_41778_().length());
        poseStack.m_85849_();
    }

    public static void renderItemWithDragon(BlockEntity block, double x, double y, double z, List<Float> size, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1, ItemStack itemStack, Color color) {
        BlockRendererUtil.renderItemWithDragon(block.m_58899_(), x, y, z, size, poseStack, multiBufferSource, i, i1, itemStack, color);
    }

    public static void renderItemWithDragon(BlockPos pos, double x, double y, double z, List<Float> size, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1, ItemStack itemStack, Color color) {
        BlockRendererUtil.renderItem(pos, x, y, z, size, poseStack, multiBufferSource, i, i1, itemStack);
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).replaceBufferSource(multiBufferSource).setAlpha(0.5f).setColor(color).renderDragon(poseStack, x, BlockRendererUtil.getItemY() + y + 0.15, z, 1.0f, ClientTickHandler.partialTicks, itemStack.m_41778_().length());
    }

    public static BaseItemStackHandler getItemHandler(BlockSimpleInventory blockSimpleInventory) {
        BaseItemStackHandler itemStackHandler = new BaseItemStackHandler(blockSimpleInventory.getItemHandler().m_6643_(), () -> {});
        for (int i = 0; i < blockSimpleInventory.getItemHandler().m_6643_(); ++i) {
            itemStackHandler.setStackInSlot(i, blockSimpleInventory.getItemHandler().m_8020_(i));
        }
        return itemStackHandler;
    }

    public static LazyOptional<BaseItemStackHandler> getLazyItems(BlockSimpleInventory blockSimpleInventory) {
        return LazyOptional.of(() -> BlockRendererUtil.getItemHandler(blockSimpleInventory));
    }

    public static LazyOptional<IItemHandler> getLazyItems(BlockEntity blockEntity) {
        return LazyOptional.of(() -> (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)new BaseItemStackHandler(0, () -> ((BlockEntity)blockEntity).m_6596_())));
    }
}

