/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.SplitText;

public class GuiUtil {
    public static GameProfile createOfflineProfile(String playerName) {
        UUID offlineUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes());
        return new GameProfile(offlineUUID, playerName);
    }

    public static void renderFlatPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, String player) {
        GuiUtil.renderFlatPlayerHead(guiGraphics, x, y, size, GuiUtil.createOfflineProfile(player));
    }

    public static void renderFlatPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, GameProfile player) {
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public static void renderFlatPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, Player player) {
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player.m_36316_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280411_(skinTexture, x, y, size, size, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public static void render3DPlayerHeadMouse(GuiGraphics guiGraphics, int x, int y, int size, float mouseX, float mouseY, Player player) {
        GuiUtil.render3DPlayerHead(guiGraphics, x, y, size, (mouseX - (float)x) * 0.1f, (mouseY - (float)y) * 0.25f, player);
    }

    public static void render3DPlayerHead(GuiGraphics guiGraphics, int x, int y, int size, float degreeX, float degreeY, Player player) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 100.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(degreeX));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-degreeY));
        GuiUtil.renderPlayerHeadCube(player, poseStack);
        poseStack.m_85849_();
    }

    private static void renderPlayerHeadCube(Player player, PoseStack poseStack) {
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player.m_36316_());
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderType renderType = RenderType.m_110458_((ResourceLocation)skinTexture);
        VertexConsumer buffer = bufferSource.m_6299_(renderType);
        float s = 4.0f;
        int light = 0xF000F0;
        Matrix4f m = poseStack.m_85850_().m_252922_();
        Matrix3f n = poseStack.m_85850_().m_252943_();
        int overlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        float u1 = 0.125f;
        float v1 = 0.125f;
        float u2 = 0.25f;
        float v2 = 0.25f;
        buffer.m_252986_(m, -s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(m, s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(m, s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        u1 = 0.375f;
        v1 = 0.125f;
        u2 = 0.5f;
        v2 = 0.25f;
        buffer.m_252986_(m, s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, -s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        u1 = 0.0f;
        v1 = 0.125f;
        u2 = 0.125f;
        v2 = 0.25f;
        buffer.m_252986_(m, -s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        u1 = 0.25f;
        v1 = 0.125f;
        u2 = 0.375f;
        v2 = 0.25f;
        buffer.m_252986_(m, s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        u1 = 0.125f;
        v1 = 0.0f;
        u2 = 0.25f;
        v2 = 0.125f;
        buffer.m_252986_(m, -s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, -s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        u1 = 0.25f;
        v1 = 0.0f;
        u2 = 0.375f;
        v2 = 0.125f;
        buffer.m_252986_(m, -s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, s, s).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -s, s, -s).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferSource.m_109911_();
    }

    public static void renderEntityFollowsMouse(GuiGraphics gui, int x, int y, int scale, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        GuiUtil.renderEntityFollowsAngle(gui, x, y, scale, f, f1, entity);
    }

    public static void renderEntityFollowsAngle(GuiGraphics gui, int x, int y, int scale, float entityLookX, float entityLookY, LivingEntity entity) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(entityLookY * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + entityLookX * 20.0f;
        entity.m_146922_(180.0f + entityLookX * 40.0f);
        entity.m_146926_(-entityLookY * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        GuiUtil.renderEntity(gui, x, y, scale, quaternionf, quaternionf1, entity);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }

    public static void renderEntityQuaternionf(GuiGraphics gui, int x, int y, int scale, Quaternionf quaternionf, Quaternionf quaternionf1, LivingEntity entity) {
        quaternionf.mul((Quaternionfc)quaternionf1);
        GuiUtil.renderEntity(gui, x, y, scale, quaternionf, quaternionf1, entity);
    }

    public static void renderEntity(GuiGraphics gui, int x, int y, int scale, Quaternionf pose, Quaternionf cameraOrientation, LivingEntity entity) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85837_((double)x, (double)y, 50.0);
        gui.m_280168_().m_252931_(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        gui.m_280168_().m_252781_(pose);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        if (cameraOrientation != null) {
            cameraOrientation.conjugate();
            entityrenderdispatcher.m_252923_(cameraOrientation);
        }
        entityrenderdispatcher.m_114468_(false);
        entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, gui.m_280168_(), (MultiBufferSource)gui.m_280091_(), 0xF000F0);
        gui.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        gui.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public static void renderScaledIngredient(GuiGraphics gui, int x, int y, Ingredient ingredient, float scale) {
        ItemStack[] stacks = ingredient.m_43908_();
        if (stacks.length == 0) {
            return;
        }
        int index = (int)(System.currentTimeMillis() / 1000L % (long)stacks.length);
        GuiUtil.renderScaledItem(gui, stacks[index], x, y, scale);
        GuiUtil.renderScaledItemDecorations(gui, stacks[index], x, y, scale);
    }

    public static void renderIngredient(GuiGraphics gui, int x, int y, Ingredient ingredient) {
        GuiUtil.renderScaledIngredient(gui, x, y, ingredient, 1.0f);
    }

    public static void renderTooltip(GuiGraphics gui, int x, int y, Ingredient ingredient, float scale) {
        ItemStack[] stacks = ingredient.m_43908_();
        if (stacks.length == 0) {
            return;
        }
        int index = (int)(System.currentTimeMillis() / 1000L % (long)stacks.length);
        ArrayList<Component> components = new ArrayList<Component>(Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stacks[index]));
        Ingredient.Value value = ingredient.f_43902_[0];
        if (value instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            components.add(1, (Component)Component.m_237113_((String)("Tag: #" + tagValue.f_43959_.f_203868_())));
        }
        GuiUtil.renderScaledTooltip(gui, components, x, y, scale);
    }

    public static void renderTooltip(GuiGraphics gui, int x, int y, Ingredient ingredient) {
        GuiUtil.renderTooltip(gui, x, y, ingredient, 1.0f);
    }

    public static void drawScaledString(GuiGraphics gui, String text, int x, int y, Color color, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.drawString(Minecraft.m_91087_().f_91062_, text, (float)x / size, (float)y / size, ColorHelper.getColor(color), true);
        gui.m_280168_().m_85849_();
    }

    public static void drawScaledString(GuiGraphics gui, Component text, int x, int y, Color color, float size) {
        GuiUtil.drawScaledString(gui, text.getString(), x, y, color, size);
    }

    public static void drawScaledCentreString(GuiGraphics gui, String text, int x, int y, Color color, float size) {
        GuiUtil.drawScaledString(gui, text, x - Minecraft.m_91087_().f_91062_.m_92895_(text) / 2, y, color, size);
    }

    public static void drawScaledCentreString(GuiGraphics gui, Component text, int x, int y, Color color, float size) {
        GuiUtil.drawScaledCentreString(gui, text.getString(), x, y, color, size);
    }

    public static void drawScaledTooltips(GuiGraphics gui, Component text, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280557_(Minecraft.m_91087_().f_91062_, text, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void drawScaledTooltips(GuiGraphics gui, List<Component> text, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280666_(Minecraft.m_91087_().f_91062_, text, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledTooltip(GuiGraphics gui, List<Component> list, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280666_(Minecraft.m_91087_().f_91062_, list, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledItem(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280480_(pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledItemTooltip(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280153_(Minecraft.m_91087_().f_91062_, pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledFakeItem(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280203_(pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void renderScaledItemDecorations(GuiGraphics gui, ItemStack pStack, int x, int y, float size) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(size, size, 1.0f);
        gui.m_280370_(Minecraft.m_91087_().f_91062_, pStack, (int)((float)x / size), (int)((float)y / size));
        gui.m_280168_().m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, int x, int y, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280159_((int)((float)x / scale), (int)((float)y / scale), pBlitOffset, pWidth, pHeight, pSprite);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, int x, int y, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite, float pRed, float pGreen, float pBlue, float pAlpha) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280565_((int)((float)x / scale), (int)((float)y / scale), pBlitOffset, pWidth, pHeight, pSprite, pRed, pGreen, pBlue, pAlpha);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280218_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pUOffset, pVOffset, pUWidth, pVHeight);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, int pBlitOffset, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280398_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pBlitOffset, pUOffset, pVOffset, pUWidth, pVHeight, pTextureWidth, pTextureHeight);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280411_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pWidth, pHeight, pUOffset, pVOffset, pUWidth, pVHeight, pTextureWidth, pTextureHeight);
        pose.m_85849_();
    }

    public static void blit(GuiGraphics gui, float scale, ResourceLocation pAtlasLocation, int x, int y, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280163_(pAtlasLocation, (int)((float)x / scale), (int)((float)y / scale), pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
        pose.m_85849_();
    }

    public static void blitNineSlicedSized(GuiGraphics gui, float scale, ResourceLocation texture, int x, int y, int width, int height, int sliceSize, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.blitNineSlicedSized(texture, (int)((float)x / scale), (int)((float)y / scale), width, height, sliceSize, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        pose.m_85849_();
    }

    public static void blitNineSlicedSized(GuiGraphics gui, float scale, ResourceLocation texture, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.blitNineSlicedSized(texture, (int)((float)x / scale), (int)((float)y / scale), width, height, sliceWidth, sliceHeight, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        pose.m_85849_();
    }

    public static void blitNineSlicedSized(GuiGraphics gui, float scale, ResourceLocation texture, int x, int y, int width, int height, int cornerWidth, int cornerHeight, int edgeWidth, int edgeHeight, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        gui.blitNineSlicedSized(texture, (int)((float)x / scale), (int)((float)y / scale), width, height, cornerWidth, cornerHeight, edgeWidth, edgeHeight, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        pose.m_85849_();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiUtil.drawGradientRect(mat, bufferBuilder, left, top, right, bottom, zLevel, startColor, endColor);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawGradientRect(Matrix4f mat, BufferBuilder bufferBuilder, int left, int top, int right, int bottom, int zLevel, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        bufferBuilder.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        bufferBuilder.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        bufferBuilder.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        bufferBuilder.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
    }

    public static void drawGradientRectHorizontal(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void blit(PoseStack poseStack, int x, int y, int width, int height, float texX, float texY, int texWidth, int texHeight, int fullWidth, int fullHeight) {
        GuiUtil.blit(poseStack, x, x + width, y, y + height, 0, texWidth, texHeight, texX, texY, fullWidth, fullHeight);
    }

    public static void blit(PoseStack poseStack, int x0, int x1, int y0, int y1, int z, int texWidth, int texHeight, float texX, float texY, int fullWidth, int fullHeight) {
        GuiUtil.innerBlit(poseStack, x0, x1, y0, y1, z, (texX + 0.0f) / (float)fullWidth, (texX + (float)texWidth) / (float)fullWidth, (texY + 0.0f) / (float)fullHeight, (texY + (float)texHeight) / (float)fullHeight);
    }

    private static void innerBlit(PoseStack poseStack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)x0, (float)y0, (float)z).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x0, (float)y1, (float)z).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x1, (float)y0, (float)z).m_7421_(u1, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable Component component, float x, float y, int color, boolean drawShadow) {
        if (component == null) {
            return 0;
        }
        int i = font.m_272077_(component, x, y, color, drawShadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_286081_();
        return i;
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable String string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        }
        int i = font.m_271703_(string, x, y, color, drawShadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_286081_();
        return i;
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable FormattedCharSequence string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        }
        int i = font.m_272191_(string, x, y, color, drawShadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_286081_();
        return i;
    }

    public static SplitText splitText(String text, int max, float scale) {
        String[] words;
        SplitText result = new SplitText(scale);
        StringBuilder currentLine = new StringBuilder();
        int currentWidth = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        for (String word : words = text.split(" ")) {
            int wordWidth = (int)((float)font.m_92895_(word + " ") * scale);
            if (word.equals("\n") || currentWidth + wordWidth > max) {
                result.add(currentLine.toString());
                currentWidth = word.equals("\n") ? 0 : wordWidth;
                currentLine = new StringBuilder();
                if (word.equals("\n")) continue;
                currentLine.append(word).append(" ");
                continue;
            }
            currentWidth += wordWidth;
            currentLine.append(word).append(" ");
        }
        return result;
    }

    public static SplitText splitText(String text, int max) {
        return GuiUtil.splitText(text, max, 1.0f);
    }

    public static String toString(List<Component> components) {
        StringBuilder builder = new StringBuilder();
        for (Component component : components) {
            builder.append(component.getString()).append(" \n ");
        }
        return builder.toString();
    }
}

