/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.utils.PlayerUtil;

@ParametersAreNonnullByDefault
public final class InitialSpawnItems {
    public static final InitialSpawnItems INSTANCE = new InitialSpawnItems();
    private static final String NBT_KEY = "blatapi.spawn_item";
    private final Map<ResourceLocation, Function<Player, Collection<ItemStack>>> spawnItems = new HashMap<ResourceLocation, Function<Player, Collection<ItemStack>>>();

    private InitialSpawnItems() {
    }

    public static void add(ResourceLocation key, Function<Player, Collection<ItemStack>> itemFactory) {
        InitialSpawnItems.INSTANCE.spawnItems.put(key, itemFactory);
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag givenItems = PlayerUtil.getPersistedDataSubcompound(player, NBT_KEY);
        this.spawnItems.forEach((key, factory) -> InitialSpawnItems.handleSpawnItems(player, givenItems, key, (Collection)factory.apply(player)));
    }

    private static void handleSpawnItems(Player player, CompoundTag givenItems, ResourceLocation key, Collection<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        String nbtKey = key.toString().replace(':', '.');
        if (!givenItems.m_128471_(nbtKey)) {
            items.forEach(stack -> {
                BlatApi.LOGGER.debug("Giving player {} spawn item \"{}\": {}", new Object[]{player.m_6302_(), nbtKey, stack});
                PlayerUtil.addItem(player, stack);
                givenItems.m_128379_(nbtKey, true);
            });
        }
    }
}

